/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.ec4j.lint.api.Linter;
import org.ec4j.lint.api.Logger;
import org.ec4j.lint.api.PathSet;

public class LinterRegistry {
    private final Map<String, LinterEntry> entries;
    private final Logger log;

    public static Builder builder() {
        return new Builder();
    }

    LinterRegistry(Map<String, LinterEntry> entries, Logger log) {
        this.entries = entries;
        Objects.requireNonNull(log, "log");
        this.log = log;
    }

    public List<Linter> filter(Path path) {
        this.log.trace("Filtering linters for file '{}'", path);
        ArrayList<Linter> result = new ArrayList<Linter>(this.entries.size());
        for (LinterEntry linterEntry : this.entries.values()) {
            if (!linterEntry.getPathSet().contains(path)) continue;
            Linter linter = linterEntry.getLinter();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Adding linter {}", linter.getClass().getName());
            }
            result.add(linter);
        }
        return Collections.unmodifiableList(result);
    }

    static class LinterEntry {
        private final Linter linter;
        private final PathSet pathSet;

        LinterEntry(Linter linter, PathSet pathSet) {
            this.linter = linter;
            this.pathSet = pathSet;
        }

        public Linter getLinter() {
            return this.linter;
        }

        public PathSet getPathSet() {
            return this.pathSet;
        }

        public static class Builder {
            private final Linter linter;
            private final PathSet.Builder pathSetBuilder = new PathSet.Builder();
            private boolean useDefaultIncludesAndExcludes = true;

            Builder(Linter linter) {
                this.linter = linter;
            }

            public LinterEntry build() {
                if (this.useDefaultIncludesAndExcludes) {
                    this.pathSetBuilder.includes(this.linter.getDefaultIncludes());
                    this.pathSetBuilder.excludes(this.linter.getDefaultExcludes());
                }
                return new LinterEntry(this.linter, this.pathSetBuilder.build());
            }
        }
    }

    public static class Builder {
        private final Map<String, LinterEntry.Builder> entries = new LinkedHashMap<String, LinterEntry.Builder>();
        private Logger log;

        Builder() {
        }

        public LinterRegistry build() {
            LinkedHashMap<String, LinterEntry> useEntries = new LinkedHashMap<String, LinterEntry>(this.entries.size());
            for (Map.Entry<String, LinterEntry.Builder> en : this.entries.entrySet()) {
                useEntries.put(en.getKey(), en.getValue().build());
            }
            return new LinterRegistry(Collections.unmodifiableMap(useEntries), this.log);
        }

        public Builder entry(Linter linter) {
            String linterClass = linter.getClass().getName();
            LinterEntry.Builder en = this.entries.get(linterClass);
            if (en == null) {
                en = new LinterEntry.Builder(linter);
                this.entries.put(linterClass, en);
            }
            return this;
        }

        public Builder entry(String id, String linterClass, ClassLoader classLoader, String[] includes, String[] excludes, boolean useDefaultIncludesAndExcludes) {
            LinterEntry.Builder en = this.entries.get(id);
            if (en == null) {
                try {
                    Class<?> cl = classLoader.loadClass(linterClass);
                    Linter linter = (Linter)cl.newInstance();
                    en = new LinterEntry.Builder(linter);
                    this.entries.put(id, en);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Could not load class " + linterClass, e);
                }
            }
            en.useDefaultIncludesAndExcludes = useDefaultIncludesAndExcludes;
            PathSet.Builder pathSetBuilder = en.pathSetBuilder;
            pathSetBuilder.includes(includes);
            pathSetBuilder.excludes(excludes);
            return this;
        }

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder removeEntry(String id) {
            this.entries.remove(id);
            return this;
        }

        public Builder scan(ClassLoader classLoader) {
            ServiceLoader<Linter> loader = ServiceLoader.load(Linter.class, classLoader);
            for (Linter linter : loader) {
                this.entry(linter);
            }
            return this;
        }
    }
}

