/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

public class LintUtils {
    private LintUtils() {
    }

    public static StringBuilder escape(StringBuilder output, char[] source) {
        return LintUtils.escape(output, source, 0, source.length);
    }

    public static StringBuilder escape(StringBuilder output, char[] source, int offset, int length) {
        int end = offset + length;
        block6: while (offset < end) {
            char ch = source[offset++];
            switch (ch) {
                case '\r': {
                    output.append("\\r");
                    continue block6;
                }
                case '\n': {
                    output.append("\\n");
                    continue block6;
                }
                case '\t': {
                    output.append("\\t");
                    continue block6;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block6;
                }
            }
            output.append(ch);
        }
        return output;
    }

    public static String escape(String source) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return "";
        }
        char[] sourceChars = source.toCharArray();
        for (int i = 0; i < sourceChars.length; ++i) {
            switch (sourceChars[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\\': {
                    StringBuilder sb = new StringBuilder(sourceChars.length + 2);
                    sb.append(sourceChars, 0, i);
                    LintUtils.escape(sb, sourceChars, i, sourceChars.length - i);
                    return sb.toString();
                }
            }
        }
        return source;
    }

    public static int validateLineOrColumnNumber(int number, String name) {
        if (number < 1) {
            throw new IllegalArgumentException(String.format("%s must be greater or equal to 1", name));
        }
        return number;
    }

    public static int validateLength(int length, String name) {
        if (length < 0) {
            throw new IllegalArgumentException(String.format("%s must be greater or equal to 0", name));
        }
        return length;
    }
}

