/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.AssertionErrorFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.util.Strings;
import org.fest.util.Throwables;
import org.fest.util.VisibleForTesting;

public class Failures {
    private static final Failures INSTANCE = new Failures();
    private boolean removeFestRelatedElementsFromStackTrace = true;

    public static Failures instance() {
        return INSTANCE;
    }

    public void setRemoveFestRelatedElementsFromStackTrace(boolean removeFestRelatedElementsFromStackTrace) {
        this.removeFestRelatedElementsFromStackTrace = removeFestRelatedElementsFromStackTrace;
    }

    @VisibleForTesting
    Failures() {
    }

    public AssertionError failure(AssertionInfo info, AssertionErrorFactory factory) {
        AssertionError error = this.failureIfErrorMessageIsOverriden(info);
        if (error != null) {
            return error;
        }
        return factory.newAssertionError(info.description());
    }

    public AssertionError failure(AssertionInfo info, ErrorMessageFactory message) {
        AssertionError error = this.failureIfErrorMessageIsOverriden(info);
        if (error != null) {
            return error;
        }
        AssertionError assertionError = new AssertionError((Object)message.create(info.description()));
        this.removeFestRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    private AssertionError failureIfErrorMessageIsOverriden(AssertionInfo info) {
        String overridingErrorMessage = info.overridingErrorMessage();
        if (!Strings.isEmpty((String)overridingErrorMessage)) {
            return this.failure(overridingErrorMessage);
        }
        return null;
    }

    public AssertionError failure(String message) {
        AssertionError assertionError = new AssertionError((Object)message);
        this.removeFestRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    public void removeFestRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (this.removeFestRelatedElementsFromStackTrace) {
            Throwables.removeFestRelatedElementsFromStackTrace((Throwable)((Object)assertionError));
        }
    }
}

