/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.IndexedObjectEnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.ObjectArrays;
import org.fest.util.Collections;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayAssert<T>
extends AbstractAssert<ObjectArrayAssert<T>, T[]>
implements IndexedObjectEnumerableAssert<ObjectArrayAssert<T>, T>,
ArraySortedAssert<ObjectArrayAssert<T>, T> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();

    protected ObjectArrayAssert(T[] actual) {
        super(actual, ObjectArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public ObjectArrayAssert<T> isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> contains(Object ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> containsOnly(Object ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> containsExactly(Object ... values) {
        this.objects.assertEqual(this.info, this.actual, Collections.list((Object[])values));
        return this;
    }

    @Override
    public ObjectArrayAssert<T> containsSequence(Object ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> contains(Object value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> doesNotContain(Object value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> doesNotContain(Object ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> startsWith(Object ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> endsWith(Object ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> are(Condition<? super T> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areNot(Condition<? super T> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> have(Condition<? super T> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> doNotHave(Condition<? super T> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areNotAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertAreNotAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areNotAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertAreNotAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areExactly(int times, Condition<? super T> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> areNotExactly(int times, Condition<? super T> condition) {
        this.arrays.assertAreNotExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> haveAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> doNotHaveAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertDoNotHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> haveAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> doNotHaveAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertDoNotHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> haveExactly(int times, Condition<? super T> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> doNotHaveExactly(int times, Condition<? super T> condition) {
        this.arrays.assertDoNotHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> isSortedAccordingTo(Comparator<? super T> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> containsAll(Iterable<? extends T> iterable) {
        this.arrays.assertContainsAll(this.info, (Object[])this.actual, iterable);
        return this;
    }

    @Override
    public ObjectArrayAssert<T> usingElementComparator(Comparator<? super T> customComparator) {
        this.arrays = new ObjectArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert<T> usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (ObjectArrayAssert)this.myself;
    }
}

