/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ComparableAssert;
import org.fest.assertions.internal.Comparables;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComparableAssert<S extends AbstractComparableAssert<S, A>, A extends Comparable<? super A>>
extends AbstractAssert<S, A>
implements ComparableAssert<S, A> {
    @VisibleForTesting
    Comparables comparables = Comparables.instance();

    protected AbstractComparableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S isLessThan(A other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(A other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isGreaterThan(A other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(A other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        super.usingComparator((Comparator)customComparator);
        this.comparables = new Comparables((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.comparables = Comparables.instance();
        return (S)((AbstractComparableAssert)this.myself);
    }
}

