/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.groups;

import org.fest.assertions.internal.PropertySupport;
import org.fest.assertions.util.ArrayWrapperList;
import org.fest.util.VisibleForTesting;

public class Properties<T> {
    @VisibleForTesting
    final String propertyName;
    final Class<T> propertyType;
    @VisibleForTesting
    PropertySupport propertySupport = PropertySupport.instance();

    public static <T> Properties<T> extractProperty(String propertyName, Class<T> propertyType) {
        Properties.checkIsNotNullOrEmpty(propertyName);
        return new Properties<T>(propertyName, propertyType);
    }

    public static Properties<Object> extractProperty(String propertyName) {
        return Properties.extractProperty(propertyName, Object.class);
    }

    private static void checkIsNotNullOrEmpty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The name of the property to read should not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("The name of the property to read should not be empty");
        }
    }

    @VisibleForTesting
    Properties(String propertyName, Class<T> propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public <U> Properties<U> ofType(Class<U> propertyType) {
        return Properties.extractProperty(this.propertyName, propertyType);
    }

    public Iterable<T> from(Iterable<?> c) {
        return this.propertySupport.propertyValues(this.propertyName, this.propertyType, c);
    }

    public Iterable<T> from(Object[] array) {
        return this.propertySupport.propertyValues(this.propertyName, this.propertyType, ArrayWrapperList.wrap(array));
    }
}

