/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.ShortArrays;
import org.fest.util.VisibleForTesting;

public class ShortArrayAssert
extends AbstractAssert<ShortArrayAssert, short[]>
implements EnumerableAssert<ShortArrayAssert, Short>,
ArraySortedAssert<ShortArrayAssert, Short> {
    @VisibleForTesting
    ShortArrays arrays = ShortArrays.instance();

    protected ShortArrayAssert(short[] actual) {
        super(actual, ShortArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (short[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (short[])this.actual);
    }

    @Override
    public ShortArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (short[])this.actual);
        return this;
    }

    @Override
    public ShortArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (short[])this.actual, expected);
        return this;
    }

    @Override
    public ShortArrayAssert hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (short[])this.actual, other);
        return this;
    }

    @Override
    public ShortArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (short[])this.actual, other);
        return this;
    }

    public ShortArrayAssert contains(short ... values) {
        this.arrays.assertContains(this.info, (short[])this.actual, values);
        return this;
    }

    public ShortArrayAssert containsOnly(short ... values) {
        this.arrays.assertContainsOnly(this.info, (short[])this.actual, values);
        return this;
    }

    public ShortArrayAssert containsSequence(short ... sequence) {
        this.arrays.assertContainsSequence(this.info, (short[])this.actual, sequence);
        return this;
    }

    public ShortArrayAssert contains(short value, Index index) {
        this.arrays.assertContains(this.info, (short[])this.actual, value, index);
        return this;
    }

    public ShortArrayAssert doesNotContain(short ... values) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, values);
        return this;
    }

    public ShortArrayAssert doesNotContain(short value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, value, index);
        return this;
    }

    public ShortArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (short[])this.actual);
        return this;
    }

    public ShortArrayAssert startsWith(short ... sequence) {
        this.arrays.assertStartsWith(this.info, (short[])this.actual, sequence);
        return this;
    }

    public ShortArrayAssert endsWith(short ... sequence) {
        this.arrays.assertEndsWith(this.info, (short[])this.actual, sequence);
        return this;
    }

    @Override
    public ShortArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (short[])this.actual);
        return this;
    }

    @Override
    public ShortArrayAssert isSortedAccordingTo(Comparator<? super Short> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (short[])this.actual, comparator);
        return this;
    }

    @Override
    public ShortArrayAssert usingElementComparator(Comparator<? super Short> customComparator) {
        this.arrays = new ShortArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (ShortArrayAssert)this.myself;
    }

    @Override
    public ShortArrayAssert usingDefaultElementComparator() {
        this.arrays = ShortArrays.instance();
        return (ShortArrayAssert)this.myself;
    }
}

