/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.quartz;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easyrules.api.RulesEngine;
import org.easyrules.quartz.RulesEngineJob;
import org.easyrules.quartz.RulesEngineJobFactory;
import org.easyrules.quartz.RulesEngineSchedulerException;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;

public class RulesEngineScheduler {
    private static final Logger LOGGER = Logger.getLogger(RulesEngineScheduler.class.getName());
    private static final String JOB_NAME_PREFIX = "re-";
    private static final String TRIGGER_NAME_PREFIX = "trigger-for-re-";
    private Scheduler scheduler;
    private static RulesEngineScheduler instance;

    public static RulesEngineScheduler getInstance() throws RulesEngineSchedulerException {
        if (instance == null) {
            instance = new RulesEngineScheduler();
        }
        return instance;
    }

    RulesEngineScheduler() throws RulesEngineSchedulerException {
        RulesEngineJobFactory jobFactory = new RulesEngineJobFactory();
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            this.scheduler = schedulerFactory.getScheduler();
            this.scheduler.setJobFactory((JobFactory)jobFactory);
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("An exception occurred during scheduler setup", e);
        }
    }

    public void scheduleAt(RulesEngine engine, Date startTime) throws RulesEngineSchedulerException {
        RulesEngineScheduler.checkNotNull(engine, "engine");
        RulesEngineScheduler.checkNotNull(startTime, "startTime");
        String engineName = engine.getParameters().getName();
        String jobName = JOB_NAME_PREFIX + engineName;
        String triggerName = TRIGGER_NAME_PREFIX + engineName;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).startAt(startTime).forJob(jobName).build();
        JobDetail job = this.getJobDetail(engine, jobName);
        try {
            LOGGER.log(Level.INFO, "Scheduling engine ''{0}'' to start at {1}", new Object[]{engine, startTime});
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("Unable to schedule engine " + engine, e);
        }
    }

    public void scheduleAtWithInterval(RulesEngine engine, Date startTime, int interval) throws RulesEngineSchedulerException {
        RulesEngineScheduler.checkNotNull(engine, "engine");
        RulesEngineScheduler.checkNotNull(startTime, "startTime");
        String engineName = engine.getParameters().getName();
        String jobName = JOB_NAME_PREFIX + engineName;
        String triggerName = TRIGGER_NAME_PREFIX + engineName;
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(interval).repeatForever();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).startAt(startTime).withSchedule((ScheduleBuilder)scheduleBuilder).forJob(jobName).build();
        JobDetail job = this.getJobDetail(engine, jobName);
        try {
            LOGGER.log(Level.INFO, "Scheduling engine ''{0}'' to start at {1} and every {2} second(s)", new Object[]{engine, startTime, interval});
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("Unable to schedule engine " + engine, e);
        }
    }

    public void scheduleCron(RulesEngine engine, String cronExpression) throws RulesEngineSchedulerException {
        RulesEngineScheduler.checkNotNull(engine, "engine");
        RulesEngineScheduler.checkNotNull(cronExpression, "cronExpression");
        String engineName = engine.getParameters().getName();
        String jobName = JOB_NAME_PREFIX + engineName;
        String triggerName = TRIGGER_NAME_PREFIX + engineName;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(jobName).build();
        JobDetail job = this.getJobDetail(engine, jobName);
        try {
            LOGGER.log(Level.INFO, "Scheduling engine ''{0}'' with cron expression {1}", new Object[]{engine, cronExpression});
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("Unable to schedule engine " + engine, e);
        }
    }

    public void unschedule(RulesEngine engine) throws RulesEngineSchedulerException {
        LOGGER.log(Level.INFO, "Unscheduling engine ''{0}'' ", engine);
        try {
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)(TRIGGER_NAME_PREFIX + engine.getParameters().getName())));
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("Unable to unschedule engine " + engine, e);
        }
    }

    public boolean isScheduled(RulesEngine engine) throws RulesEngineSchedulerException {
        try {
            return this.scheduler.checkExists(TriggerKey.triggerKey((String)(TRIGGER_NAME_PREFIX + engine.getParameters().getName())));
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("Unable to check if the engine '" + engine + "' is scheduled", e);
        }
    }

    public void start() throws RulesEngineSchedulerException {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("An exception occurred during scheduler startup", e);
        }
    }

    public void stop() throws RulesEngineSchedulerException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("An exception occurred during scheduler shutdown", e);
        }
    }

    public boolean isStarted() throws RulesEngineSchedulerException {
        try {
            return this.scheduler.isStarted();
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("An exception occurred during checking if the scheduler is started", e);
        }
    }

    public boolean isStopped() throws RulesEngineSchedulerException {
        try {
            return this.scheduler.isShutdown();
        }
        catch (SchedulerException e) {
            throw new RulesEngineSchedulerException("An exception occurred during checking if the scheduler is stopped", e);
        }
    }

    private JobDetail getJobDetail(RulesEngine engine, String jobName) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("engine", (Object)engine);
        return JobBuilder.newJob(RulesEngineJob.class).withIdentity(jobName).usingJobData(jobDataMap).build();
    }

    private static void checkNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The %s must not be null", argumentName));
        }
    }
}

