/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.easyrules.annotation.Action;
import org.easyrules.annotation.Condition;
import org.easyrules.annotation.Priority;
import org.easyrules.annotation.Rule;
import org.easyrules.core.ActionMethodOrderBean;
import org.easyrules.core.RuleDefinitionValidator;
import org.easyrules.util.Utils;

class RuleProxy
implements InvocationHandler {
    private Object target;
    private static RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();

    public RuleProxy(Object target) {
        this.target = target;
    }

    public static org.easyrules.api.Rule asRule(Object rule) {
        org.easyrules.api.Rule result;
        if (Utils.getInterfaces(rule).contains(org.easyrules.api.Rule.class)) {
            result = (org.easyrules.api.Rule)rule;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(rule);
            result = (org.easyrules.api.Rule)Proxy.newProxyInstance(org.easyrules.api.Rule.class.getClassLoader(), new Class[]{org.easyrules.api.Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(rule));
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getName")) {
            return this.getRuleName();
        }
        if (methodName.equals("getDescription")) {
            return this.getRuleDescription();
        }
        if (methodName.equals("getPriority")) {
            return this.getRulePriority();
        }
        if (methodName.equals("evaluate")) {
            return this.getConditionMethod().invoke(this.target, args);
        }
        if (methodName.equals("execute")) {
            for (ActionMethodOrderBean actionMethodBean : this.getActionMethodBeans()) {
                actionMethodBean.getMethod().invoke(this.target, new Object[0]);
            }
        }
        if (methodName.equals("equals")) {
            return this.target.equals(args[0]);
        }
        if (methodName.equals("hashCode")) {
            return this.target.hashCode();
        }
        if (methodName.equals("toString")) {
            return this.target.toString();
        }
        if (methodName.equals("compareTo")) {
            Method compareToMethod = this.getCompareToMethod();
            if (compareToMethod != null) {
                return compareToMethod.invoke(this.target, args);
            }
            org.easyrules.api.Rule otherRule = (org.easyrules.api.Rule)args[0];
            return this.compareTo(otherRule);
        }
        return null;
    }

    private int compareTo(org.easyrules.api.Rule otherRule) throws Exception {
        String otherName = otherRule.getName();
        int otherPriority = otherRule.getPriority();
        String name = this.getRuleName();
        int priority = this.getRulePriority();
        if (priority < otherPriority) {
            return -1;
        }
        if (priority > otherPriority) {
            return 1;
        }
        return name.compareTo(otherName);
    }

    private int getRulePriority() throws Exception {
        Method[] methods;
        int priority = 0x7FFFFFFE;
        for (Method method : methods = this.getMethods()) {
            if (!method.isAnnotationPresent(Priority.class)) continue;
            priority = (Integer)method.invoke(this.target, new Object[0]);
            break;
        }
        return priority;
    }

    private Method getConditionMethod() {
        Method[] methods;
        for (Method method : methods = this.getMethods()) {
            if (!method.isAnnotationPresent(Condition.class)) continue;
            return method;
        }
        return null;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        Method[] methods = this.getMethods();
        TreeSet<ActionMethodOrderBean> actionMethodBeans = new TreeSet<ActionMethodOrderBean>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            Action actionAnnotation = method.getAnnotation(Action.class);
            int order = actionAnnotation.order();
            actionMethodBeans.add(new ActionMethodOrderBean(method, order));
        }
        return actionMethodBeans;
    }

    private Method getCompareToMethod() {
        Method[] methods;
        for (Method method : methods = this.getMethods()) {
            if (!method.getName().equals("compareTo")) continue;
            return method;
        }
        return null;
    }

    private Method[] getMethods() {
        return this.getTargetClass().getMethods();
    }

    private Rule getRuleAnnotation() {
        return (Rule)Utils.findAnnotation(Rule.class, this.getTargetClass());
    }

    private String getRuleName() {
        Rule rule = this.getRuleAnnotation();
        return rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
    }

    private String getRuleDescription() {
        StringBuilder description = new StringBuilder();
        this.appendConditionMethodName(description);
        this.appendActionMethodsNames(description);
        Rule rule = this.getRuleAnnotation();
        return rule.description().equals("description") ? description.toString() : rule.description();
    }

    private void appendConditionMethodName(StringBuilder description) {
        Method method = this.getConditionMethod();
        if (method != null) {
            description.append("when ");
            description.append(method.getName());
            description.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder description) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            description.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            description.append(",");
        }
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

