/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.impl.ReportRunner;
import org.easetech.easytest.util.CommonUtils;
import org.easetech.easytest.util.TestInfo;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAftersWithOutputData
extends Statement {
    protected static final Logger LOG = LoggerFactory.getLogger(RunAftersWithOutputData.class);
    private Map<String, List<Map<String, Object>>> writableData;
    private final Statement fNext;
    private final Object fTarget;
    private final List<TestInfo> testInfoList;
    private final List<FrameworkMethod> fAfters;
    private ReportDataContainer testReportContainer;

    public RunAftersWithOutputData(Statement next, List<FrameworkMethod> afters, Object target, List<TestInfo> testInfoList, Map<String, List<Map<String, Object>>> writableData, ReportDataContainer testReportContainer) {
        this.fNext = next;
        this.fAfters = afters;
        this.fTarget = target;
        this.testInfoList = testInfoList;
        this.writableData = writableData;
        this.testReportContainer = testReportContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        Report annotation;
        LOG.info("evaluate started");
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.fNext.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            for (FrameworkMethod each : this.fAfters) {
                try {
                    each.invokeExplosively(this.fTarget, new Object[0]);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        MultipleFailureException.assertEmpty(errors);
        for (TestInfo testInfo : this.testInfoList) {
            if (testInfo.getFilePaths() == null || testInfo.getDataLoader() == null) continue;
            try {
                testInfo.getDataLoader().writeData(testInfo.getFilePaths(), testInfo.getMethodName(), this.writableData);
            }
            catch (Exception e) {
                throw new ParameterizedAssertionError((Throwable)e, testInfo.getMethodName(), new Object[]{testInfo});
            }
        }
        if (this.testReportContainer != null && (annotation = this.testReportContainer.getTestClass().getAnnotation(Report.class)) != null) {
            String outputLocationFromAnnotation = annotation.outputLocation();
            String absoluteLocation = CommonUtils.getAbsoluteLocation(outputLocationFromAnnotation);
            String outputLocation = CommonUtils.createFolder(absoluteLocation);
            if (outputLocation != null) {
                Report.EXPORT_FORMAT[] outputFormats = annotation.outputFormats();
                LOG.info("Reporting phase started " + new Date());
                LOG.info("Writing reports to folder: " + outputLocation);
                ReportRunner testReportHelper = new ReportRunner(this.testReportContainer);
                testReportHelper.runReports(outputFormats, outputLocation);
                LOG.info("Reporting phase finished " + new Date());
            } else {
                LOG.error("Can't write reports. Report output location " + outputLocationFromAnnotation + " can't be created.");
            }
        }
        LOG.info("evaluate finished");
    }
}

