/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtils.class);
    private static final String FILE_SEPARATOR = String.valueOf(File.separatorChar);

    public static Double getRounded(double valueToRound, int numberOfDecimalPlaces) {
        BigDecimal bigDecimal = new BigDecimal(valueToRound).setScale(numberOfDecimalPlaces, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static String createDefaultOutputFolder(String destinationFolder) {
        if (destinationFolder == null || destinationFolder.equals("")) {
            destinationFolder = System.getProperty("user.dir") + File.separatorChar + "target" + File.separatorChar + "reports";
        }
        return CommonUtils.createFolder(destinationFolder);
    }

    public static String getCurrentFolder() {
        File file = new File("");
        String absolutePath = file.getAbsolutePath();
        return absolutePath;
    }

    public static String createFolder(String absoluteLocation) {
        if (absoluteLocation == null) {
            return null;
        }
        File file = new File(absoluteLocation);
        if (!file.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)file);
            }
            catch (IOException e) {
                LOG.error("Error creating directory " + absoluteLocation + " (" + e.getMessage() + ")");
            }
        }
        return absoluteLocation;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat instance = new SimpleDateFormat("ddMMyyyyHHmmss");
        return instance.format(date);
    }

    public static String getAbsoluteLocation(String location) {
        String path = null;
        if (location.equals("")) {
            return CommonUtils.getCurrentFolder();
        }
        if (location.startsWith("file:")) {
            path = location.substring(location.indexOf(":") + 1, location.length());
        } else if (location.startsWith("classpath:")) {
            path = location.substring(location.indexOf(":") + 1, location.length());
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(".");
            try {
                File file = new File(url.toURI());
                String tempPath = file.toString();
                if (!tempPath.endsWith(FILE_SEPARATOR)) {
                    tempPath = tempPath + FILE_SEPARATOR;
                }
                path = path.replace("/", FILE_SEPARATOR);
                path = tempPath + path;
            }
            catch (URISyntaxException e) {
                LOG.error("URI exception ", (Throwable)e);
            }
        } else {
            LOG.error("Report output location " + location + " not found");
        }
        return path;
    }
}

