/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.annotation.Intercept;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.loader.LoaderFactory;
import org.easetech.easytest.loader.LoaderType;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.runner.EasyTestRunListener;
import org.easetech.easytest.util.DataContext;
import org.easetech.easytest.util.RunAftersWithOutputData;
import org.easetech.easytest.util.TestInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTestRunner
extends Suite {
    private static Map<String, List<Map<String, Object>>> writableData = new HashMap<String, List<Map<String, Object>>>();
    private static int rowNum = 0;
    private String mapMethodName = "";
    private ReportDataContainer testReportContainer = null;
    protected static final Logger PARAM_LOG = LoggerFactory.getLogger(SpringTestRunner.class);
    private final ArrayList<Runner> runners = new ArrayList();
    private List<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
    private List<FrameworkMethod> methodsWithData = new ArrayList<FrameworkMethod>();

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public SpringTestRunner(Class<?> klass) throws InitializationError {
        super(klass, Collections.EMPTY_LIST);
        Class testClass = this.getTestClass().getJavaClass();
        this.loadData(klass, null, testClass);
        List availableMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
        ArrayList<FrameworkMethod> methodsWithData = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : availableMethods) {
            if (method.getAnnotation(DataLoader.class) != null) {
                methodsWithData.add(method);
                continue;
            }
            boolean methodDataLoaded = this.isMethodDataLoaded(DataConverter.getFullyQualifiedTestName(method.getName(), testClass));
            if (methodDataLoaded) {
                methodsWithData.add(method);
                continue;
            }
            methodsWithNoData.add(method);
        }
        if (!methodsWithNoData.isEmpty()) {
            this.methodsWithNoData = methodsWithNoData;
        }
        if (!methodsWithData.isEmpty()) {
            this.methodsWithData = methodsWithData;
        }
        this.runners.add((Runner)new EasyTestRunner(klass));
    }

    protected Statement withBeforeClasses(Statement statement) {
        return statement;
    }

    protected boolean isMethodDataLoaded(String methodName) {
        boolean result = false;
        if (DataContext.getData() == null || DataContext.getData().keySet() == null || DataContext.getData().keySet().isEmpty()) {
            result = false;
        } else {
            Iterator<String> keyIterator = DataContext.getData().keySet().iterator();
            while (keyIterator.hasNext() && !(result = methodName.equals(keyIterator.next()))) {
            }
        }
        return result;
    }

    protected void loadData(Class<?> testClass, FrameworkMethod method, Class<?> currentTestClass) {
        if (testClass == null && method == null) {
            Assert.fail((String)"The framework should provide either the testClass parameter or the method parameter in order to load the test data.");
        }
        DataLoader testData = null;
        testData = testClass != null ? testClass.getAnnotation(DataLoader.class) : (DataLoader)method.getAnnotation(DataLoader.class);
        if (testData != null) {
            TestInfo testInfo = this.determineLoader(testData, this.getTestClass());
            Loader dataLoader = testInfo.getDataLoader();
            if (testInfo.getDataLoader() == null) {
                Assert.fail((String)"The framework currently does not support the specified Loader type. You can provide the custom Loader by choosing LoaderType.CUSTOM in TestData annotation and providing your custom loader using DataLoader annotation.");
            } else {
                Map<String, List<Map<String, Object>>> data = dataLoader.loadData(testInfo.getFilePaths());
                writableData.putAll(data);
                DataContext.setData(DataConverter.appendClassName(data, currentTestClass));
                DataContext.setConvertedData(DataConverter.convert(data, currentTestClass));
            }
        }
    }

    protected Statement withAfterClasses(Statement statement) {
        return statement;
    }

    private TestInfo determineLoader(DataLoader testData, TestClass testClass) {
        TestInfo result = new TestInfo(testClass);
        String[] dataFiles = testData.filePaths();
        LoaderType loaderType = testData.loaderType();
        Loader dataLoader = null;
        if (LoaderType.CUSTOM.equals((Object)loaderType)) {
            PARAM_LOG.info("User specified to use custom Loader. Trying to get the custom loader.");
            if (testData.loader() == null) {
                Assert.fail((String)"Specified the LoaderType as CUSTOM but did not specify loader attribute. A loaderType of CUSTOM requires the loader attribute specifying the Custom Loader Class which implements Loader interface.");
            } else {
                try {
                    Class<? extends Loader> loaderClass = testData.loader();
                    dataLoader = loaderClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while trying to instantiate a class of type :" + testData.loader(), e);
                }
            }
        } else if (dataFiles.length == 0) {
            if (testData.loader() == null) {
                Assert.fail((String)"Specified the LoaderType as CUSTOM but did not specify loader attribute. A loaderType of CUSTOM requires the loader attribute specifying the Custom Loader Class which implements Loader interface.");
            } else {
                try {
                    Class<? extends Loader> loaderClass = testData.loader();
                    dataLoader = loaderClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while trying to instantiate a class of type :" + testData.loader(), e);
                }
            }
        } else {
            dataLoader = LoaderFactory.getLoader(loaderType);
        }
        result.setDataLoader(dataLoader);
        result.setFilePaths(dataFiles);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EasyTestRunner
    extends SpringJUnit4ClassRunner {
        List<FrameworkMethod> frameworkMethods;
        Object testInstance;

        public EasyTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
            try {
                this.testInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
                this.getTestContextManager().prepareTestInstance(this.testInstance);
                this.instrumentClass(this.getTestClass().getJavaClass());
            }
            catch (Exception e) {
                Assert.fail((String)("Test failed while trying to instrument fileds in the class : " + this.getTestClass().getJavaClass()));
            }
        }

        protected void instrumentClass(Class<?> testClass) throws IllegalArgumentException, IllegalAccessException, AopConfigException, InstantiationException {
            Field[] fields;
            for (Field field : fields = testClass.getFields()) {
                Intercept interceptor = field.getAnnotation(Intercept.class);
                if (interceptor == null) continue;
                Class<? extends MethodInterceptor> interceptorClass = interceptor.interceptor();
                Object fieldInstance = field.get(this.testInstance);
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget(fieldInstance);
                factory.addAdvice((Advice)interceptorClass.newInstance());
                Object proxy = factory.getProxy();
                try {
                    field.set(this.testInstance, proxy);
                }
                catch (Exception e) {
                    Assert.fail((String)("Failed while trying to instrument the class for Intercept annotation with exception : " + e.getStackTrace()));
                }
            }
        }

        protected void collectInitializationErrors(List<Throwable> errors) {
            super.collectInitializationErrors(errors);
            this.validateDataPointFields(errors);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s", method.getName());
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.frameworkMethods != null && !this.frameworkMethods.isEmpty()) {
                return this.frameworkMethods;
            }
            ArrayList<FrameworkMethod> finalList = new ArrayList<FrameworkMethod>();
            Class testClass = this.getTestClass().getJavaClass();
            block0: for (FrameworkMethod methodWithData : SpringTestRunner.this.methodsWithData) {
                String superMethodName = DataConverter.getFullyQualifiedTestName(methodWithData.getName(), testClass);
                for (FrameworkMethod method : super.computeTestMethods()) {
                    if (!superMethodName.equals(DataConverter.getFullyQualifiedTestName(method.getName(), testClass))) continue;
                    SpringTestRunner.this.loadData(null, method, this.getTestClass().getJavaClass());
                    List<Map<String, Object>> methodData = DataContext.getData().get(superMethodName);
                    if (methodData == null) {
                        Assert.fail((String)("Method with name : " + superMethodName + " expects some input test data. But there doesnt seem to be any test " + "data for the given method. Please check the Test Data file for the method data. " + "Possible cause could be a spelling mismatch."));
                    }
                    for (Map<String, Object> testData : methodData) {
                        EasyFrameworkMethod easyMethod = new EasyFrameworkMethod(method.getMethod());
                        easyMethod.setName(method.getName().concat(testData.toString()));
                        finalList.add(easyMethod);
                    }
                    continue block0;
                }
            }
            finalList.addAll(SpringTestRunner.this.methodsWithNoData);
            if (finalList.isEmpty()) {
                Assert.fail((String)"No method exists for the Test Runner");
            }
            this.frameworkMethods = finalList;
            return finalList;
        }

        private void validateDataPointFields(List<Throwable> errors) {
            Field[] fields;
            for (Field each : fields = this.getTestClass().getJavaClass().getDeclaredFields()) {
                if (each.getAnnotation(DataPoint.class) == null || Modifier.isStatic(each.getModifiers())) continue;
                errors.add(new Error("DataPoint field " + each.getName() + " must be static"));
            }
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected void validateTestMethods(List<Throwable> errors) {
        }

        protected Object createTest() throws Exception {
            return null;
        }

        public Statement methodBlock(FrameworkMethod method) {
            return new ParamAnchor(method, this.getTestClass());
        }

        protected Statement withAfterClasses(Statement statement) {
            List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
            List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
            ArrayList<TestInfo> testInfoList = new ArrayList<TestInfo>();
            TestInfo testInfo = null;
            for (FrameworkMethod method : testMethods) {
                DataLoader loaderAnnotation = (DataLoader)method.getAnnotation(DataLoader.class);
                if (loaderAnnotation != null) {
                    testInfo = SpringTestRunner.this.determineLoader(loaderAnnotation, this.getTestClass());
                } else {
                    loaderAnnotation = this.getTestClass().getJavaClass().getAnnotation(DataLoader.class);
                    if (loaderAnnotation != null) {
                        testInfo = SpringTestRunner.this.determineLoader(loaderAnnotation, this.getTestClass());
                    }
                }
                if (testInfo == null) continue;
                testInfo.setMethodName(method.getName());
                testInfoList.add(testInfo);
            }
            return new RunAftersWithOutputData(statement, afters, null, testInfoList, writableData, SpringTestRunner.this.testReportContainer);
        }

        public class ParamAnchor
        extends Statement {
            protected final Logger LOG = LoggerFactory.getLogger(ParamAnchor.class);
            private int successes = 0;
            private FrameworkMethod fTestMethod;
            private TestClass fTestClass;
            private List<Assignments> listOfAssignments;
            private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();

            public ParamAnchor(FrameworkMethod method, TestClass testClass) {
                this.fTestMethod = method;
                this.fTestClass = testClass;
                this.listOfAssignments = new ArrayList<Assignments>();
                DataContext.setMethodName(DataConverter.getFullyQualifiedTestName(method.getName(), testClass.getJavaClass()));
            }

            private TestClass getTestClass() {
                return this.fTestClass;
            }

            public void evaluate() throws Throwable {
                this.runWithAssignment(Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass()));
                this.LOG.debug("ParamAnchor evaluate");
                if (this.successes == 0) {
                    Assert.fail((String)("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters));
                }
            }

            protected void runWithAssignment(Assignments parameterAssignment) throws Throwable {
                while (!parameterAssignment.isComplete()) {
                    List potentialAssignments = parameterAssignment.potentialsForNextUnassigned();
                    boolean isFirstSetOfArguments = this.listOfAssignments.isEmpty();
                    for (int i = 0; i < potentialAssignments.size(); ++i) {
                        Assignments assignments;
                        if (isFirstSetOfArguments) {
                            assignments = Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass());
                            this.listOfAssignments.add(assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                            continue;
                        }
                        assignments = this.listOfAssignments.get(i);
                        try {
                            this.listOfAssignments.set(i, assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                            continue;
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.listOfAssignments.add(assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                        }
                    }
                    parameterAssignment = parameterAssignment.assignNext(null);
                }
                if (this.listOfAssignments.isEmpty()) {
                    this.LOG.debug("The list of Assignments is null. It normally happens when the user has not supplied any parameters to the test.");
                    this.LOG.debug(" Creating an instance of Assignments object with all its value unassigned.");
                    this.listOfAssignments.add(Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass()));
                }
                for (Assignments assignments : this.listOfAssignments) {
                    this.runWithCompleteAssignment(assignments);
                }
            }

            protected void runWithCompleteAssignment(final Assignments complete) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
                new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

                    protected void collectInitializationErrors(List<Throwable> errors) {
                    }

                    public Statement methodBlock(FrameworkMethod method) {
                        final Statement statement = super.methodBlock(method);
                        RunNotifier notifier = new RunNotifier();
                        notifier.addListener((RunListener)new EasyTestRunListener());
                        final EachTestNotifier eachNotifier = new EachTestNotifier(notifier, null);
                        eachNotifier.fireTestStarted();
                        return new Statement(){

                            public void evaluate() throws Throwable {
                                try {
                                    statement.evaluate();
                                    ParamAnchor.this.handleDataPointSuccess();
                                }
                                catch (AssumptionViolatedException e) {
                                    eachNotifier.addFailedAssumption(e);
                                    ParamAnchor.this.handleAssumptionViolation(e);
                                }
                                catch (Throwable e) {
                                    eachNotifier.addFailure(e);
                                    throw e;
                                }
                                finally {
                                    eachNotifier.fireTestFinished();
                                }
                            }
                        };
                    }

                    protected Statement methodInvoker(FrameworkMethod method, Object test) {
                        return ParamAnchor.this.methodCompletesWithParameters(method, complete, test);
                    }

                    public Object createTest() throws Exception {
                        return EasyTestRunner.this.testInstance;
                    }
                }.methodBlock(this.fTestMethod).evaluate();
            }

            private Statement methodCompletesWithParameters(final FrameworkMethod method, final Assignments complete, final Object freshInstance) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        try {
                            Object[] values = complete.getMethodArguments(true);
                            Object returnObj = method.invokeExplosively(freshInstance, values);
                            if (returnObj != null) {
                                ParamAnchor.this.LOG.debug("returnObj:" + returnObj);
                                if (!SpringTestRunner.this.mapMethodName.equals(method.getMethod().getName())) {
                                    SpringTestRunner.this.mapMethodName = method.getMethod().getName();
                                    rowNum = 0;
                                }
                                ParamAnchor.this.LOG.debug("mapMethodName:" + SpringTestRunner.this.mapMethodName + " ,rowNum:" + rowNum);
                                if (writableData.get(SpringTestRunner.this.mapMethodName) != null) {
                                    ParamAnchor.this.LOG.debug("writableData.get(mapMethodName)" + writableData.get(SpringTestRunner.this.mapMethodName) + " ,rowNum:" + rowNum);
                                    ((Map)((List)writableData.get(SpringTestRunner.this.mapMethodName)).get(rowNum++)).put("ActualResult", returnObj);
                                }
                            }
                        }
                        catch (PotentialAssignment.CouldNotGenerateValueException couldNotGenerateValueException) {
                            // empty catch block
                        }
                    }
                };
            }

            protected void handleAssumptionViolation(AssumptionViolatedException e) {
                this.fInvalidParameters.add(e);
            }

            protected void handleDataPointSuccess() {
                ++this.successes;
            }
        }
    }
}

