/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.ReportTotalsBean;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.reports.utils.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportBuilder {
    private ReportDataContainer reportDataContainer;

    public ReportBuilder(ReportDataContainer reportDataContainer) {
        this.reportDataContainer = reportDataContainer;
    }

    public JRDataSource buildTestReport(Map<String, Object> reportParameters) {
        JRBeanCollectionDataSource defaultDataSource = new JRBeanCollectionDataSource(this.reportDataContainer.getTestResults());
        this.fillReportDataParameters(reportParameters);
        return defaultDataSource;
    }

    private void fillReportDataParameters(Map<String, Object> reportParameters) {
        Map<String, List<TestResultBean>> methodTestResults = this.reportDataContainer.getMethodTestResults();
        ArrayList<ReportTotalsBean> reportTotalsBeans = new ArrayList<ReportTotalsBean>();
        for (String methodname : methodTestResults.keySet()) {
            ReportTotalsBean createTestMethodSummary = this.createTestMethodSummary(methodTestResults.get(methodname));
            createTestMethodSummary.setTotalsGraph(this.getPercentageImage(methodname, createTestMethodSummary));
            reportParameters.put(methodname, createTestMethodSummary);
            reportTotalsBeans.add(createTestMethodSummary);
        }
        String className = this.reportDataContainer.getClassName();
        ReportTotalsBean createTestClassSummary = this.createTestClassSummary(reportTotalsBeans);
        createTestClassSummary.setTotalsGraph(this.getPercentageImage(className, createTestClassSummary));
        reportParameters.put(className, createTestClassSummary);
    }

    public ReportTotalsBean createTestMethodSummary(List<TestResultBean> testResultBeans) {
        ReportTotalsBean testReportTotals = new ReportTotalsBean();
        for (TestResultBean testResultBean : testResultBeans) {
            if (testResultBean.getPassed() != null && testResultBean.getPassed().booleanValue()) {
                testReportTotals.addPassed();
                continue;
            }
            if (testResultBean.getPassed() != null && !testResultBean.getPassed().booleanValue()) {
                testReportTotals.addFailed();
                continue;
            }
            if (testResultBean.getException() == null || !testResultBean.getException().booleanValue()) continue;
            testReportTotals.addException();
        }
        return testReportTotals;
    }

    public ReportTotalsBean createTestClassSummary(List<ReportTotalsBean> testReportTotalsList) {
        ReportTotalsBean testReportTotals = new ReportTotalsBean();
        testReportTotals.setItem("");
        for (ReportTotalsBean reportTotalsBean : testReportTotalsList) {
            testReportTotals.addPassed(reportTotalsBean.getPassed());
            testReportTotals.addFailed(reportTotalsBean.getFailed());
            testReportTotals.addException(reportTotalsBean.getException());
        }
        return testReportTotals;
    }

    public void createTestReportSummaryGraphs(ReportTotalsBean reportTotalsBean) {
    }

    private BufferedImage getPercentageImage(String itemName, ReportTotalsBean testReportTotals) {
        LinkedHashMap<String, Double> totalsDatasetValuesMap = new LinkedHashMap<String, Double>();
        totalsDatasetValuesMap.put("Passed (" + testReportTotals.getPercentagePassed() + "%)", testReportTotals.getPercentagePassed());
        totalsDatasetValuesMap.put("Failed (" + testReportTotals.getPercentageFailed() + "%)", testReportTotals.getPercentageFailed());
        totalsDatasetValuesMap.put("Exception (" + testReportTotals.getPercentageException() + "%)", testReportTotals.getPercentageException());
        DefaultPieDataset pieChartDataset = ChartUtils.getPieChartDataset(totalsDatasetValuesMap);
        JFreeChart pieChart = ChartUtils.getPieChart("", pieChartDataset);
        BufferedImage percentageImage = ChartUtils.getBufferedImageChartImage(pieChart, 220, 220);
        return percentageImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum REPORT_TYPES {
        ALL,
        DEFAULT,
        PERFORMANCE;

    }
}

