/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.util.ResourceLoader;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(ExcelDataLoader.class);
    private transient Map<String, List<Map<String, Object>>> data = null;

    public ExcelDataLoader() {
    }

    public ExcelDataLoader(InputStream excelInputStream) throws IOException {
        this.data = this.loadFromSpreadsheet(excelInputStream);
    }

    public Map<String, List<Map<String, Object>>> getData() {
        return this.data;
    }

    private Map<String, List<Map<String, Object>>> loadFromSpreadsheet(InputStream excelFile) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(excelFile);
        this.data = new HashMap<String, List<Map<String, Object>>>();
        HSSFSheet sheet = workbook.getSheetAt(0);
        int numberOfColumns = this.countNonEmptyColumns((Sheet)sheet);
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        HashMap<Integer, Object> tempData = new HashMap<Integer, Object>();
        ArrayList<HashMap<String, Object>> dataValues = null;
        for (Row row : sheet) {
            boolean isFirstColumn = true;
            boolean keyRow = false;
            HashMap<String, Object> actualData = new HashMap<String, Object>();
            for (int column = 0; column < numberOfColumns; ++column) {
                Cell cell = row.getCell(column);
                Object cellData = this.objectFrom(workbook, cell);
                if (isFirstColumn && cellData != null) {
                    dataValues = new ArrayList<HashMap<String, Object>>();
                    keyRow = true;
                    finalData.put(cellData.toString().trim(), dataValues);
                } else if (cellData != null) {
                    if (keyRow) {
                        tempData.put(column, this.objectFrom(workbook, cell));
                    } else {
                        actualData.put(tempData.get(column).toString(), this.objectFrom(workbook, cell));
                    }
                }
                isFirstColumn = false;
            }
            if (keyRow) continue;
            dataValues.add(actualData);
        }
        return finalData;
    }

    private int countNonEmptyColumns(Sheet sheet) {
        Row firstRow = sheet.getRow(0);
        return this.firstEmptyCellPosition(firstRow);
    }

    private int firstEmptyCellPosition(Row cells) {
        Cell cell;
        int columnCount = 0;
        Iterator i$ = cells.iterator();
        while (i$.hasNext() && (cell = (Cell)i$.next()).getCellType() != 3) {
            ++columnCount;
        }
        return columnCount;
    }

    private Object objectFrom(HSSFWorkbook workbook, Cell cell) {
        Object cellValue = null;
        if (cell == null || cell.getCellType() == 3) {
            cellValue = null;
        } else if (cell.getCellType() == 1) {
            cellValue = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 0) {
            cellValue = this.getNumericCellValue(cell);
        } else if (cell.getCellType() == 4) {
            cellValue = cell.getBooleanCellValue();
        } else if (cell.getCellType() == 2) {
            cellValue = this.evaluateCellFormula(workbook, cell);
        }
        return cellValue;
    }

    private Object getNumericCellValue(Cell cell) {
        Object cellValue;
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            cellValue = new Date(cell.getDateCellValue().getTime());
        } else {
            cellValue = cell.getNumericCellValue();
            if (cellValue != null && cellValue.toString().endsWith(".0")) {
                cellValue = cellValue.toString().replace(".0", "");
            }
        }
        return cellValue;
    }

    private Object evaluateCellFormula(HSSFWorkbook workbook, Cell cell) {
        HSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        Object result = null;
        if (cellValue.getCellType() == 4) {
            result = cellValue.getBooleanValue();
        } else if (cellValue.getCellType() == 0) {
            result = cellValue.getNumberValue();
        } else if (cellValue.getCellType() == 1) {
            result = cellValue.getStringValue();
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> loadExcelData(List<String> dataFiles) throws IOException {
        LOG.debug("loadExcelData started", dataFiles);
        Map<String, List<Map<String, Object>>> data = null;
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        for (String filePath : dataFiles) {
            try {
                ResourceLoader resource = new ResourceLoader(filePath);
                data = this.loadFromSpreadsheet(resource.getInputStream());
            }
            catch (FileNotFoundException e) {
                LOG.error("The specified file was not found. The path is : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            catch (IOException e) {
                LOG.error("IO Exception occured while trying to read the data from the file : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            finalData.putAll(data);
        }
        LOG.debug("loadExcelData finisihed", finalData);
        return finalData;
    }

    @Override
    public Map<String, List<Map<String, Object>>> loadData(String[] filePaths) {
        LOG.info("loadData started" + filePaths);
        HashMap<String, List<Map<String, Object>>> result = new HashMap();
        try {
            result = this.loadExcelData(Arrays.asList(filePaths));
        }
        catch (IOException e) {
            Assert.fail((String)("An I/O exception occured while reading the files from the path :" + filePaths.toString()));
        }
        LOG.debug("loadData finished" + result);
        LOG.info("loadData finished");
        return result;
    }

    @Override
    public void writeData(String[] filePaths, String methodName, Map<String, List<Map<String, Object>>> map) {
        LOG.debug("writeData started, filePath:" + filePaths + ", data map size:" + map.size() + ", data map:" + map);
        try {
            this.writeExcelData(filePaths[0], methodName, map);
        }
        catch (IOException e) {
            Assert.fail((String)("An I/O exception occured while reading the files from the path :" + filePaths[0]));
        }
        LOG.info("writeData finished");
    }

    private void writeExcelData(String filePath, String methodName, Map<String, List<Map<String, Object>>> data) throws IOException {
        LOG.debug("writeExcelData started" + filePath + data.size());
        try {
            ResourceLoader resource = new ResourceLoader(filePath);
            this.writeDataToSpreadsheet(resource, methodName, data);
        }
        catch (FileNotFoundException e) {
            LOG.error("The specified file was not found. The path is : {}", (Object)filePath);
            LOG.error("Continuing with the loading of next file.");
        }
        catch (IOException e) {
            LOG.error("IO Exception occured while trying to read the data from the file : {}", (Object)filePath);
            LOG.error("Continuing with the loading of next file.");
        }
        LOG.debug("writeExcelData finished" + filePath + data.size());
    }

    private void writeDataToSpreadsheet(ResourceLoader resource, String methodNameForDataLoad, Map<String, List<Map<String, Object>>> data) throws IOException {
        Workbook workbook;
        LOG.debug("writeDataToSpreadsheet started" + resource.toString() + data);
        try {
            workbook = WorkbookFactory.create((POIFSFileSystem)new POIFSFileSystem(resource.getInputStream()));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        Sheet sheet = workbook.getSheetAt(0);
        for (String methodName : data.keySet()) {
            int rowNum = 0;
            if (!methodName.equals(methodNameForDataLoad)) continue;
            boolean isActualResultHeaderWritten = false;
            for (Map<String, Object> methodData : data.get(methodName)) {
                Integer recordNum;
                ++rowNum;
                Object actualResult = methodData.get("ActualResult");
                if (actualResult == null) continue;
                int columnNum = methodData.size();
                if (!isActualResultHeaderWritten && (recordNum = this.getMethodRowNumFromExcel(sheet, methodName)) != null) {
                    this.writeDataToCell(sheet, recordNum, columnNum, "ActualResult");
                    rowNum += recordNum.intValue();
                    isActualResultHeaderWritten = true;
                }
                LOG.info("rowNum:" + rowNum);
                if (!isActualResultHeaderWritten) continue;
                LOG.debug("actualResult:" + actualResult.toString());
                this.writeDataToCell(sheet, rowNum, columnNum, actualResult.toString());
                Object testStatus = methodData.get("TestStatus");
                if (testStatus == null) continue;
                LOG.debug("testStatus:" + testStatus.toString());
                this.writeDataToCell(sheet, rowNum, columnNum + 1, testStatus.toString());
            }
        }
        workbook.write((OutputStream)resource.getFileOutputStream());
        LOG.debug("writeDataToSpreadsheet finished");
    }

    private Integer getMethodRowNumFromExcel(Sheet sheet, String methodName) {
        Integer rowNum = null;
        for (Row row : sheet) {
            String cellData;
            Cell cell = row.getCell(0);
            if (cell == null || (cellData = cell.getStringCellValue()) == null || !methodName.equals(cellData.trim())) continue;
            rowNum = cell.getRow().getRowNum();
            break;
        }
        LOG.debug("getMethodRowNumFromExcel finished:" + methodName + rowNum);
        return rowNum;
    }

    private void writeDataToCell(Sheet sheet, int rowNum, int columnNum, String value) {
        Row row = sheet.getRow(rowNum);
        Cell cell = row.getCell(columnNum);
        if (cell == null) {
            cell = row.createCell(columnNum);
        }
        cell.setCellType(1);
        cell.setCellValue(value);
    }
}

