/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.HashMap;
import java.util.Map;

public final class ConfigContext {
    public static final InheritableThreadLocal<Map<String, Object>> beansByName = new InheritableThreadLocal();
    public static final InheritableThreadLocal<Map<Class, Object>> beansByType = new InheritableThreadLocal();

    private ConfigContext() {
    }

    public static void setTestBeanByName(String beanName, Object beanInstance) {
        HashMap<String, Object> beanNamesMap = (HashMap<String, Object>)beansByName.get();
        if (beanNamesMap == null) {
            beanNamesMap = new HashMap<String, Object>();
        }
        beanNamesMap.put(beanName, beanInstance);
        beansByName.set(beanNamesMap);
    }

    public static void setTestBeanByType(Class beanType, Object beanInstance) {
        HashMap<Class, Object> beanTypesMap = (HashMap<Class, Object>)beansByType.get();
        if (beanTypesMap == null) {
            beanTypesMap = new HashMap<Class, Object>();
        }
        beanTypesMap.put(beanType, beanInstance);
        beansByType.set(beanTypesMap);
    }

    public static Object getBeanByName(String beanName) {
        Map beanNamesMap = (Map)beansByName.get();
        if (beanNamesMap == null) {
            return null;
        }
        return beanNamesMap.get(beanName);
    }

    public static Object getBeanByType(Class beanType) {
        Map beanTypesMap = (Map)beansByType.get();
        if (beanTypesMap == null) {
            return null;
        }
        return beanTypesMap.get(beanType);
    }

    public static void cleanConfigContext() {
        beansByName.remove();
        beansByType.remove();
    }
}

