/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.strategy;

import org.easetech.easytest.annotation.Parallel;
import org.easetech.easytest.annotation.ParallelSuite;
import org.easetech.easytest.internal.SystemProperties;
import org.easetech.easytest.strategy.ParallelScheduler;
import org.easetech.easytest.strategy.SerialScheduler;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerStrategy {
    public static RunnerScheduler getScheduler(Class<?> testClass, Boolean policyApplied) {
        Parallel parallelAnnotation = testClass.getAnnotation(Parallel.class);
        String parallelThreadsStr = System.getProperty(SystemProperties.PARALLEL_THREAD_COUNT.getValue());
        Integer parallelThreads = null;
        if (parallelThreadsStr != null) {
            parallelThreads = Integer.valueOf(parallelThreadsStr);
        }
        if (parallelThreads != null) {
            if (parallelThreads <= 0) {
                return new ParallelScheduler();
            }
            return new ParallelScheduler(parallelThreads);
        }
        if (parallelAnnotation != null) {
            if (parallelAnnotation.threads() <= 0) {
                return new ParallelScheduler();
            }
            return new ParallelScheduler(parallelAnnotation.threads());
        }
        if (policyApplied.booleanValue()) {
            return null;
        }
        return new SerialScheduler();
    }

    public static RunnerScheduler getSchedulerForSuite(Class<?> suiteClass) {
        ParallelSuite parallelSuite = suiteClass.getAnnotation(ParallelSuite.class);
        if (parallelSuite != null) {
            if (parallelSuite.threads() <= 0) {
                return new ParallelScheduler();
            }
            return new ParallelScheduler(parallelSuite.threads());
        }
        return new SerialScheduler();
    }
}

