/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.RunnerScheduler;

public class ParallelScheduler
implements RunnerScheduler {
    private final ExecutorService executorService;

    public ParallelScheduler() {
        this.executorService = Executors.newCachedThreadPool();
    }

    public ParallelScheduler(int threadsToStart) {
        this.executorService = Executors.newFixedThreadPool(threadsToStart);
    }

    public void schedule(Runnable childStatement) {
        this.executorService.submit(childStatement);
    }

    public void finished() {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

