/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.easetech.easytest.annotation.Provided;
import org.easetech.easytest.annotation.TestBean;
import org.easetech.easytest.annotation.TestConfigProvider;
import org.easetech.easytest.annotation.TestProperties;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.io.ResourceLoaderStrategy;
import org.easetech.easytest.util.ConfigContext;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestConfigUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(TestConfigUtil.class);

    public static void loadTestBeanConfig(Class<?> testClass) {
        TestConfigProvider configProvider = testClass.getAnnotation(TestConfigProvider.class);
        if (configProvider != null) {
            try {
                TestConfigUtil.loadConfigBeans(configProvider.value());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void loadConfigBeans(Class<?> ... configClasses) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        for (Class<?> configClass : configClasses) {
            Method[] methods;
            Object classInstance = configClass.newInstance();
            TestConfigUtil.loadResourceProperties(configClass, classInstance);
            for (Method method : methods = configClass.getDeclaredMethods()) {
                TestBean testBean = method.getAnnotation(TestBean.class);
                if (testBean == null) continue;
                String beanName = testBean.value();
                Class<?> beanType = method.getReturnType();
                Object[] params = new Object[]{};
                Object object = method.invoke(classInstance, params);
                if (beanName.length() > 0) {
                    ConfigContext.setTestBeanByName(beanName, object);
                }
                ConfigContext.setTestBeanByType(beanType, object);
            }
        }
    }

    public static void loadResourceProperties(Class<?> configClass, Object classInstance) {
        TestProperties resource = configClass.getAnnotation(TestProperties.class);
        if (resource != null) {
            Properties properties = TestConfigUtil.getProperties(resource, configClass);
            TestConfigUtil.setPropertiesFields(configClass, classInstance, properties);
        } else {
            TestConfigUtil.setPropertiesFields(configClass, classInstance, null);
        }
    }

    private static void setPropertiesFields(Class<?> configClass, Object classInstance, Properties properties) {
        Field[] fields;
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Properties.class)) continue;
            field.setAccessible(true);
            try {
                Properties fieldProperties = null;
                TestProperties fieldResource = field.getAnnotation(TestProperties.class);
                if (fieldResource == null) continue;
                fieldProperties = TestConfigUtil.getProperties(fieldResource, configClass);
                field.set(classInstance, fieldProperties != null ? fieldProperties : properties);
            }
            catch (Exception e) {
                LOG.error("An exception occured while trying to set the Properties instance on the class {}. Exception is : {}", configClass, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static Properties getProperties(TestProperties resource, Class<?> configClass) {
        Properties properties = new Properties();
        ResourceLoaderStrategy resourceLoader = new ResourceLoaderStrategy(configClass);
        for (String resourcePath : resource.value()) {
            Resource fileResource = resourceLoader.getResource(resourcePath);
            if (fileResource.exists()) {
                try {
                    properties.load(fileResource.getInputStream());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occured while trying to load the properties from file : " + resourcePath, e);
                }
            }
            Assert.fail((String)("Properties file with path " + resourcePath + " does not exist."));
        }
        return properties;
    }

    public static void loadTestConfigurations(Class<?> testClass, Object testInstance) {
        Field[] fields;
        for (Field field : fields = testClass.getDeclaredFields()) {
            Provided providedAnnotation = field.getAnnotation(Provided.class);
            if (providedAnnotation != null) {
                String providerBeanName = providedAnnotation.value();
                TestConfigUtil.injectTestBean(providerBeanName, field, testInstance);
                continue;
            }
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            Named namedInjection = field.getAnnotation(Named.class);
            String providerBeanName = null;
            if (namedInjection != null) {
                providerBeanName = namedInjection.value();
            }
            TestConfigUtil.injectTestBean(providerBeanName, field, testInstance);
        }
    }

    private static void injectTestBean(String providerBeanName, Field field, Object testInstance) {
        Object beanInstance = null;
        if (providerBeanName != null && providerBeanName.length() > 0) {
            beanInstance = ConfigContext.getBeanByName(providerBeanName);
        } else {
            Class<?> beanClass = field.getType();
            beanInstance = ConfigContext.getBeanByType(beanClass);
            if (beanInstance == null) {
                beanInstance = ConfigContext.getBeanByName(field.getName());
            }
        }
        try {
            LOG.debug("Field {} is being set with the instance {}", (Object)field.getName(), beanInstance);
            field.setAccessible(true);
            field.set(testInstance, beanInstance);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed while trying to handle Provider annotation for Field : " + field.getDeclaringClass() + e.getStackTrace()));
        }
    }
}

