/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.annotation.Display;
import org.easetech.easytest.annotation.PreserveContext;
import org.easetech.easytest.annotation.Repeat;
import org.easetech.easytest.annotation.TestPolicy;
import org.easetech.easytest.internal.SystemProperties;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.DataLoaderUtil;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.runner.TestConfigUtil;
import org.easetech.easytest.strategy.SchedulerStrategy;
import org.easetech.easytest.util.DataContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerUtil {
    public static RunnerScheduler getScheduler(Class<?> testClass) {
        RunnerScheduler scheduler = null;
        TestPolicy testPolicy = testClass.getAnnotation(TestPolicy.class);
        if (testPolicy != null) {
            Class<?> policyClass = testPolicy.value();
            scheduler = SchedulerStrategy.getScheduler(policyClass, false);
            RunnerScheduler testClassScheduler = SchedulerStrategy.getScheduler(testClass, true);
            if (testClassScheduler != null) {
                scheduler = testClassScheduler;
            }
        } else {
            scheduler = SchedulerStrategy.getScheduler(testClass, false);
        }
        return scheduler;
    }

    public static void loadBeanConfiguration(Class<?> testClass) {
        TestPolicy testPolicy = testClass.getAnnotation(TestPolicy.class);
        if (testPolicy != null) {
            TestConfigUtil.loadTestBeanConfig(testPolicy.value());
        }
        TestConfigUtil.loadTestBeanConfig(testClass);
    }

    public static void loadClassLevelData(Class<?> klass, TestClass testClass, Map<String, List<Map<String, Object>>> writableData) {
        TestPolicy testPolicy = testClass.getJavaClass().getAnnotation(TestPolicy.class);
        if (testPolicy != null) {
            DataLoaderUtil.loadData(testPolicy.value(), null, testClass, writableData);
        }
        DataLoaderUtil.loadData(klass, null, testClass, writableData);
    }

    public static void categorizeTestMethods(List<FrameworkMethod> methodsWithNoData, List<FrameworkMethod> methodsWithData, TestClass testClazz, Map<String, List<Map<String, Object>>> writableData) {
        List availableMethods = testClazz.getAnnotatedMethods(Test.class);
        Class testClass = testClazz.getJavaClass();
        for (FrameworkMethod method : availableMethods) {
            if (method.getAnnotation(DataLoader.class) != null) {
                DataLoaderUtil.loadData(null, method, testClazz, writableData);
                methodsWithData.add(method);
                continue;
            }
            if (method.getMethod().getParameterTypes().length == 0) {
                methodsWithNoData.add(method);
                continue;
            }
            boolean methodDataLoaded = DataLoaderUtil.isMethodDataLoaded(DataConverter.getFullyQualifiedTestName(method.getName(), testClass));
            if (methodDataLoaded) {
                methodsWithData.add(method);
                continue;
            }
            methodsWithNoData.add(method);
        }
    }

    public static void handleMethodsWithData(List<FrameworkMethod> methodsWithData, List<FrameworkMethod> finalList, TestClass testClazz, ReportDataContainer testReportContainer) {
        Class testClass = testClazz.getJavaClass();
        List availableMethods = testClazz.getAnnotatedMethods(Test.class);
        block0: for (FrameworkMethod methodWithData : methodsWithData) {
            String superMethodName = DataConverter.getFullyQualifiedTestName(methodWithData.getName(), testClass);
            for (FrameworkMethod method : availableMethods) {
                if (!superMethodName.equals(DataConverter.getFullyQualifiedTestName(method.getName(), testClass))) continue;
                List<Map<String, Object>> methodData = null;
                if (DataContext.getData() != null) {
                    methodData = DataContext.getData().get(superMethodName);
                }
                if (methodData == null || methodData.isEmpty()) {
                    Assert.fail((String)("Method with name : " + superMethodName + " expects some input test data. But there doesnt seem to be any test " + "data for the given method. Please check the Test Data file for the method data. " + "Possible cause could be that the data did not get loaded at all from the file " + "or a spelling mismatch in the method name. Check logs for more details."));
                }
                Boolean runInContext = false;
                PreserveContext preserveContext = (PreserveContext)method.getAnnotation(PreserveContext.class);
                if (preserveContext != null) {
                    runInContext = preserveContext.value();
                }
                Boolean isParent = true;
                EasyFrameworkMethod parentMethod = null;
                for (Map<String, Object> testData : methodData) {
                    EasyFrameworkMethod easyMethod;
                    TestResultBean testResultBean;
                    Repeat repeatTests;
                    if (runInContext.booleanValue()) {
                        repeatTests = (Repeat)method.getAnnotation(Repeat.class);
                        if (repeatTests != null || RunnerUtil.getRepeatCount() != null) {
                            int repeatCount = RunnerUtil.getRepeatCount() != null ? RunnerUtil.getRepeatCount().intValue() : repeatTests.times();
                            for (int count = 0; count < repeatCount; ++count) {
                                testResultBean = new TestResultBean(methodWithData.getMethod().getName(), new Date());
                                testReportContainer.addTestResult(testResultBean);
                                easyMethod = new EasyFrameworkMethod(method.getMethod(), testData, testResultBean, method.getName().concat(testData.toString()));
                                easyMethod.setName(method.getName().concat("_").concat(String.valueOf(count)).concat(testData.toString()));
                                if (isParent.booleanValue()) {
                                    ArrayList<EasyFrameworkMethod> childMethods = new ArrayList<EasyFrameworkMethod>();
                                    easyMethod.setChildMethods(childMethods);
                                    finalList.add(easyMethod);
                                    isParent = false;
                                    parentMethod = easyMethod;
                                    continue;
                                }
                                parentMethod.getChildMethods().add(easyMethod);
                            }
                            continue;
                        }
                        TestResultBean testResultBean2 = new TestResultBean(methodWithData.getMethod().getName(), new Date());
                        testReportContainer.addTestResult(testResultBean2);
                        EasyFrameworkMethod easyMethod2 = new EasyFrameworkMethod(method.getMethod(), testData, testResultBean2, method.getName().concat(testData.toString()));
                        easyMethod2.setName(method.getName().concat(testData.toString()));
                        if (isParent.booleanValue()) {
                            ArrayList<EasyFrameworkMethod> childMethods = new ArrayList<EasyFrameworkMethod>();
                            easyMethod2.setChildMethods(childMethods);
                            isParent = false;
                            finalList.add(easyMethod2);
                            parentMethod = easyMethod2;
                            continue;
                        }
                        parentMethod.getChildMethods().add(easyMethod2);
                        continue;
                    }
                    repeatTests = (Repeat)method.getAnnotation(Repeat.class);
                    if (repeatTests != null || RunnerUtil.getRepeatCount() != null) {
                        int repeatCount = RunnerUtil.getRepeatCount() != null ? RunnerUtil.getRepeatCount().intValue() : repeatTests.times();
                        for (int count = 0; count < repeatCount; ++count) {
                            testResultBean = new TestResultBean(methodWithData.getMethod().getName(), new Date());
                            testReportContainer.addTestResult(testResultBean);
                            easyMethod = new EasyFrameworkMethod(method.getMethod(), testData, testResultBean, method.getName().concat(testData.toString()));
                            easyMethod.setName(method.getName().concat("_").concat(String.valueOf(count)).concat(testData.toString()));
                            finalList.add(easyMethod);
                        }
                        continue;
                    }
                    TestResultBean testResultBean3 = new TestResultBean(methodWithData.getMethod().getName(), new Date());
                    testReportContainer.addTestResult(testResultBean3);
                    EasyFrameworkMethod easyMethod3 = new EasyFrameworkMethod(method.getMethod(), testData, testResultBean3, method.getName().concat(testData.toString()));
                    easyMethod3.setName(method.getName().concat(testData.toString()));
                    finalList.add(easyMethod3);
                }
                continue block0;
            }
        }
    }

    public static Integer getRepeatCount() {
        Integer count = null;
        String repeatCount = System.getProperty(SystemProperties.REPEAT_COUNT.getValue());
        if (repeatCount != null) {
            count = Integer.valueOf(repeatCount);
        }
        return count;
    }

    public static void handleMethodsWithNoData(List<FrameworkMethod> methodsWithNoData, List<FrameworkMethod> finalList, ReportDataContainer testReportContainer) {
        for (FrameworkMethod fMethod : methodsWithNoData) {
            Repeat repeatTests = (Repeat)fMethod.getAnnotation(Repeat.class);
            if (repeatTests != null || RunnerUtil.getRepeatCount() != null) {
                int repeatCount = RunnerUtil.getRepeatCount() != null ? RunnerUtil.getRepeatCount().intValue() : repeatTests.times();
                for (int count = 0; count < repeatCount; ++count) {
                    TestResultBean testResultBean = new TestResultBean(fMethod.getMethod().getName(), new Date());
                    testReportContainer.addTestResult(testResultBean);
                    EasyFrameworkMethod easyMethod = new EasyFrameworkMethod(fMethod.getMethod(), null, testResultBean, fMethod.getName());
                    easyMethod.setName(fMethod.getName().concat("_").concat(String.valueOf(count)));
                    finalList.add(easyMethod);
                }
                continue;
            }
            TestResultBean testResultBean = new TestResultBean(fMethod.getMethod().getName(), new Date());
            testReportContainer.addTestResult(testResultBean);
            EasyFrameworkMethod easyMethod = new EasyFrameworkMethod(fMethod.getMethod(), null, testResultBean, fMethod.getName());
            finalList.add(easyMethod);
        }
    }

    public static List<FrameworkMethod> testMethods(TestClass testClazz, ReportDataContainer testReportContainer, Map<String, List<Map<String, Object>>> writableData) {
        ArrayList<FrameworkMethod> finalList = new ArrayList<FrameworkMethod>();
        ArrayList<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
        ArrayList<FrameworkMethod> methodsWithData = new ArrayList<FrameworkMethod>();
        RunnerUtil.categorizeTestMethods(methodsWithNoData, methodsWithData, testClazz, writableData);
        RunnerUtil.handleMethodsWithData(methodsWithData, finalList, testClazz, testReportContainer);
        RunnerUtil.handleMethodsWithNoData(methodsWithNoData, finalList, testReportContainer);
        return finalList;
    }

    public static ClassLoader determineClassLoader(Class<?> fieldType, Class<?> testClass) {
        ClassLoader cl = testClass.getClassLoader();
        try {
            if (Class.forName(fieldType.getName(), false, cl) == fieldType) {
                return cl;
            }
            cl = Thread.currentThread().getContextClassLoader();
            if (Class.forName(fieldType.getName(), false, cl) == fieldType) {
                return cl;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getTestName(TestClass testClass, FrameworkMethod method) {
        Display displayAnnotation;
        String testName = method.getName();
        Display methodDisplay = method.getMethod().getAnnotation(Display.class);
        Display classDisplay = testClass.getJavaClass().getAnnotation(Display.class);
        Display policyDisplay = null;
        TestPolicy testPolicy = testClass.getJavaClass().getAnnotation(TestPolicy.class);
        if (testPolicy != null) {
            Class<?> policyClass = testPolicy.value();
            policyDisplay = policyClass.getAnnotation(Display.class);
        }
        Display display = methodDisplay != null ? methodDisplay : (displayAnnotation = classDisplay != null ? classDisplay : policyDisplay);
        if (displayAnnotation != null) {
            StringBuilder fieldsToConcatenate = new StringBuilder("");
            String[] fields = displayAnnotation.fields();
            EasyFrameworkMethod fMethod = (EasyFrameworkMethod)method;
            Map<String, Object> testData = fMethod.getTestData();
            if (testData != null) {
                for (int i = 0; i < fields.length; ++i) {
                    Object data = testData.get(fields[i]);
                    if (data == null) continue;
                    fieldsToConcatenate = fieldsToConcatenate.append(data.toString()).append(",");
                }
                if (!fieldsToConcatenate.toString().equals("")) {
                    if (fieldsToConcatenate.lastIndexOf(",") > 0) {
                        fieldsToConcatenate = fieldsToConcatenate.deleteCharAt(fieldsToConcatenate.lastIndexOf(","));
                    }
                    testName = method.getMethod().getName().concat("{").concat(fieldsToConcatenate.toString()).concat("}");
                }
            }
        }
        return String.format("%s", testName);
    }
}

