/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.easetech.easytest.annotation.Converters;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.annotation.Duration;
import org.easetech.easytest.annotation.Intercept;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.interceptor.Empty;
import org.easetech.easytest.interceptor.InternalInterceptor;
import org.easetech.easytest.interceptor.InternalInvocationhandler;
import org.easetech.easytest.interceptor.MethodIntercepter;
import org.easetech.easytest.loader.DataLoaderUtil;
import org.easetech.easytest.reports.data.DurationObserver;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.runner.InternalParameterizedStatement;
import org.easetech.easytest.runner.RunnerUtil;
import org.easetech.easytest.runner.TestConfigUtil;
import org.easetech.easytest.util.RunAftersWithOutputData;
import org.easetech.easytest.util.TestInfo;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDrivenTestRunner
extends BlockJUnit4ClassRunner {
    private final Logger LOG = LoggerFactory.getLogger(DataDrivenTestRunner.class);
    private Map<String, List<Map<String, Object>>> writableData = new HashMap<String, List<Map<String, Object>>>();
    private final List<FrameworkMethod> frameworkMethods;
    private final ReportDataContainer testReportContainer;
    private final DurationObserver durationObserver = new DurationObserver();

    public DataDrivenTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.setSchedulingStrategy();
        RunnerUtil.loadBeanConfiguration(this.getTestClass().getJavaClass());
        RunnerUtil.loadClassLevelData(klass, this.getTestClass(), this.writableData);
        try {
            this.testReportContainer = new ReportDataContainer(this.getTestClass().getJavaClass());
            this.testReportContainer.setDurationList(this.durationObserver.getDurationList());
            this.frameworkMethods = this.computeMethodsForTest();
        }
        catch (Exception e) {
            this.LOG.error("Exception occured while instantiating the DataDrivenTestRunner. Exception is : ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void setSchedulingStrategy() {
        Class testClass = this.getTestClass().getJavaClass();
        super.setScheduler(RunnerUtil.getScheduler(testClass));
    }

    protected List<FrameworkMethod> computeMethodsForTest() {
        List<FrameworkMethod> finalList = RunnerUtil.testMethods(this.getTestClass(), this.testReportContainer, this.writableData);
        if (finalList.isEmpty()) {
            Assert.fail((String)"No method exists for the Test Runner");
        }
        return finalList;
    }

    protected Object getTestInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected void loadTestConfigurations(Object testInstance) {
        TestConfigUtil.loadTestConfigurations(this.getTestClass().getJavaClass(), testInstance);
    }

    protected void loadResourceProperties(Object testInstance) {
        TestConfigUtil.loadResourceProperties(this.getTestClass().getJavaClass(), testInstance);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.frameworkMethods;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<FrameworkMethod> iter = this.frameworkMethods.iterator();
        while (iter.hasNext()) {
            FrameworkMethod each = iter.next();
            if (this.shouldRun(filter, each)) {
                try {
                    filter.apply((Object)each);
                }
                catch (NoTestsRemainException e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
        if (this.frameworkMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    protected Description describeChild(FrameworkMethod method) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
    }

    private boolean shouldRun(Filter filter, FrameworkMethod each) {
        return filter.shouldRun(this.describeFiltarableChild(each));
    }

    private Description describeFiltarableChild(FrameworkMethod each) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)each.getMethod().getName(), (Annotation[])each.getAnnotations());
    }

    protected void instrumentClass(Class<?> testClass, Object testInstance) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Field[] fields;
        for (Field field : fields = testClass.getDeclaredFields()) {
            field.setAccessible(true);
            Intercept interceptor = field.getAnnotation(Intercept.class);
            if (interceptor != null) {
                this.provideProxyWrapperFor(interceptor.interceptor(), null, field, testInstance);
                continue;
            }
            Duration duration = field.getAnnotation(Duration.class);
            if (duration == null) continue;
            this.provideProxyWrapperFor(duration.interceptor(), duration.timeInMillis(), field, testInstance);
        }
    }

    public void registerConverter(Converters converter) {
        Class<? extends Converter>[] convertersToRegister;
        if (converter != null && (convertersToRegister = converter.value()) != null && convertersToRegister.length != 0) {
            for (Class<? extends Converter> value : convertersToRegister) {
                ConverterManager.registerConverter(value);
            }
        }
    }

    protected String testName(FrameworkMethod method) {
        return RunnerUtil.getTestName(this.getTestClass(), method);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.getTestClass().getAnnotatedMethods(Test.class).size() == 0) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return this.withTestResult((EasyFrameworkMethod)method, super.methodBlock(method));
    }

    protected Statement withTestResult(final EasyFrameworkMethod method, final Statement statement) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestResultBean testResult = method.getTestResult();
                try {
                    statement.evaluate();
                    testResult.setPassed(Boolean.TRUE);
                }
                catch (Throwable e) {
                    if (e instanceof AssertionError) {
                        testResult.setPassed(Boolean.FALSE);
                        testResult.setResult(e.getMessage());
                        throw e;
                    }
                    testResult.setException(Boolean.TRUE);
                    testResult.setExceptionResult(e.toString());
                    throw e;
                }
            }
        };
    }

    protected Object createTest() throws Exception {
        Object testInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        this.loadTestConfigurations(testInstance);
        this.loadResourceProperties(testInstance);
        this.instrumentClass(this.getTestClass().getJavaClass(), testInstance);
        this.registerConverter(this.getTestClass().getJavaClass().getAnnotation(Converters.class));
        return testInstance;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object testInstance) {
        this.registerConverter((Converters)method.getAnnotation(Converters.class));
        if (method.getAnnotation(Duration.class) != null) {
            try {
                this.handleDuration(method, testInstance);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        InternalParameterizedStatement statement = new InternalParameterizedStatement(null, (EasyFrameworkMethod)method, this.getTestClass(), testInstance);
        if (((EasyFrameworkMethod)method).getChildMethods() != null && !((EasyFrameworkMethod)method).getChildMethods().isEmpty()) {
            for (EasyFrameworkMethod childMethod : ((EasyFrameworkMethod)method).getChildMethods()) {
                try {
                    this.handleDuration(childMethod, testInstance);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                statement = new InternalParameterizedStatement(statement, childMethod, this.getTestClass(), testInstance);
            }
        }
        return statement;
    }

    private void handleDuration(FrameworkMethod method, Object testInstance) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Duration duration = (Duration)method.getAnnotation(Duration.class);
        if (duration != null) {
            if (!duration.forClass().isAssignableFrom(Empty.class)) {
                this.interceptField(duration, this.getTestClass().getJavaClass(), testInstance);
            } else {
                Assert.fail((String)"Duration annotation at the method level should have value for the 'forClass' attribute.");
            }
        }
    }

    private void interceptField(Duration duration, Class<?> testClass, Object testInstance) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Field[] fields;
        for (Field field : fields = testClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getType().isAssignableFrom(duration.forClass())) continue;
            this.provideProxyWrapperFor(duration.interceptor(), duration.timeInMillis(), field, testInstance);
        }
    }

    private void provideProxyWrapperFor(Class<? extends MethodIntercepter> interceptor, Long timeInMillies, Field field, Object testInstance) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Object fieldInstance = field.get(testInstance);
        if (fieldInstance == null) {
            Assert.fail((String)("Unable to get the instance value of field :" + field.getName() + ". Are you injecting the field using dependency injection support of Easytest? " + "Then, please check that the bean is configured in the configuration file. " + "If the problem persist, please contact anujkumar@easetech.org"));
        }
        Object targetInstance = null;
        Object proxiedObject = null;
        Class<?> fieldType = field.getType();
        Class<? extends MethodIntercepter> interceptorClass = interceptor;
        if (fieldType.isInterface()) {
            if (Proxy.isProxyClass(fieldInstance.getClass())) {
                InternalInvocationhandler handler = (InternalInvocationhandler)Proxy.getInvocationHandler(fieldInstance);
                targetInstance = handler.getTargetInstance();
            } else {
                targetInstance = fieldInstance;
            }
            proxiedObject = this.getJDKProxy(interceptorClass, timeInMillies, fieldType, targetInstance);
        } else {
            if (fieldInstance instanceof Factory) {
                Factory cglibFactory = (Factory)fieldInstance;
                InternalInterceptor internalInterceptor = (InternalInterceptor)cglibFactory.getCallback(0);
                targetInstance = internalInterceptor.getTargetInstance();
            } else {
                targetInstance = fieldInstance;
            }
            proxiedObject = this.getCGLIBProxy(interceptorClass, timeInMillies, fieldType, targetInstance);
        }
        try {
            if (proxiedObject != null) {
                field.set(testInstance, proxiedObject);
            }
        }
        catch (Exception e) {
            this.LOG.error("Failed while trying to instrument the class for Intercept annotation with exception : ", (Throwable)e);
            Assert.fail((String)("Failed while trying to instrument the class for Intercept annotation with exception : " + e));
        }
    }

    private Object getJDKProxy(Class<? extends MethodIntercepter> interceptorClass, Long timeInMillis, Class<?> fieldType, Object fieldInstance) throws InstantiationException, IllegalAccessException {
        this.LOG.debug("The field of type :" + fieldType + " will be proxied using JDK dynamic proxies.");
        ClassLoader classLoader = RunnerUtil.determineClassLoader(fieldType, this.getTestClass().getJavaClass());
        Class[] interfaces = new Class[]{fieldType};
        InternalInvocationhandler handler = new InternalInvocationhandler();
        handler.setUserIntercepter(interceptorClass.newInstance());
        handler.setTargetInstance(fieldInstance);
        handler.setExpectedRunTime(timeInMillis);
        handler.addObserver(this.durationObserver);
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    private Object getCGLIBProxy(Class<? extends MethodIntercepter> interceptorClass, Long timeInMillis, Class<?> fieldType, Object fieldInstance) throws InstantiationException, IllegalAccessException {
        this.LOG.debug("The field of type :" + fieldType + " will be proxied using CGLIB proxies.");
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(fieldType);
        InternalInterceptor cglibInterceptor = new InternalInterceptor();
        cglibInterceptor.setTargetInstance(fieldInstance);
        cglibInterceptor.setUserIntercepter(interceptorClass.newInstance());
        cglibInterceptor.setExpectedRunTime(timeInMillis);
        cglibInterceptor.addObserver(this.durationObserver);
        enhancer.setCallback((Callback)cglibInterceptor);
        return enhancer.create();
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        ArrayList<TestInfo> testInfoList = new ArrayList<TestInfo>();
        for (FrameworkMethod method : testMethods) {
            TestInfo testInfo = null;
            DataLoader loaderAnnotation = (DataLoader)method.getAnnotation(DataLoader.class);
            if (loaderAnnotation != null) {
                testInfo = DataLoaderUtil.determineLoader(loaderAnnotation, this.getTestClass());
            } else {
                loaderAnnotation = this.getTestClass().getJavaClass().getAnnotation(DataLoader.class);
                if (loaderAnnotation != null) {
                    testInfo = DataLoaderUtil.determineLoader(loaderAnnotation, this.getTestClass());
                }
            }
            if (testInfo == null) continue;
            testInfo.setMethodName(method.getName());
            testInfoList.add(testInfo);
        }
        RunAftersWithOutputData runAftersWithOutputData = new RunAftersWithOutputData(statement, afters, null, testInfoList, this.writableData, this.testReportContainer);
        return runAftersWithOutputData;
    }
}

