/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.utils;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.reports.data.Duration;
import org.easetech.easytest.reports.utils.PieChartColorRendererHelper;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUtils {
    public static BufferedImage getBufferedImageChartImage(JFreeChart chart, int width, int height) {
        BufferedImage createBufferedImage = chart.createBufferedImage(width, height);
        return createBufferedImage;
    }

    public static JFreeChart getPieChart(String title, DefaultPieDataset dataset) {
        JFreeChart pieChart = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)pieChart.getPlot();
        plot.setLabelGenerator(null);
        Color[] colors = new Color[]{Color.GREEN, Color.RED, Color.GRAY};
        PieChartColorRendererHelper renderer = new PieChartColorRendererHelper(colors);
        renderer.setColor(plot, dataset);
        return pieChart;
    }

    public static DefaultPieDataset getPieChartDataset(Map<String, Double> datasetValues) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (String datasetValueKey : datasetValues.keySet()) {
            dataset.setValue((Comparable)((Object)datasetValueKey), (Number)datasetValues.get(datasetValueKey));
        }
        return dataset;
    }

    public static CategoryDataset createDatasetDuration(List<Duration> inputDataset, String labelSeries1, String labelSeries2, String labelSeries3) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Duration duration : inputDataset) {
            dataset.addValue((double)duration.getMin(), (Comparable)((Object)labelSeries1), (Comparable)((Object)duration.getMethod()));
            dataset.addValue((double)duration.getMax(), (Comparable)((Object)labelSeries2), (Comparable)((Object)duration.getMethod()));
            dataset.addValue((double)duration.getAvg(), (Comparable)((Object)labelSeries3), (Comparable)((Object)duration.getMethod()));
        }
        return dataset;
    }

    public static CategoryDataset createDatasetCountLine(List<Duration> inputDataset, String countLabel) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Duration duration : inputDataset) {
            dataset.addValue((double)duration.getCount(), (Comparable)((Object)countLabel), (Comparable)((Object)duration.getMethod()));
        }
        return dataset;
    }

    public static JFreeChart getDualAxisChart(String chartTitle, CategoryDataset barDataset, CategoryDataset lineDataset) {
        String categoryLabel = "Legenda";
        String axisLabel = "Time (ms)";
        JFreeChart chart = ChartFactory.createBarChart((String)chartTitle, (String)categoryLabel, (String)axisLabel, (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)new Color(238, 238, 255));
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.setDataset(1, lineDataset);
        plot.mapDatasetToRangeAxis(1, 1);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        NumberAxis axis2 = new NumberAxis("# executions");
        axis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis(1, (ValueAxis)axis2);
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        plot.setRenderer(1, (CategoryItemRenderer)renderer2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        return chart;
    }
}

