/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportExporter {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExporter.class);
    private static final String DEFAULT_REPORT_JRXML = "/reports/MainReport_pdf.jrxml";
    private static final String DEFAULT_REPORT_JRXML_XLS = "/reports/MainReport_xls.jrxml";
    private JasperReport defaultMainReport;
    private JasperReport defaultMainReport_xls;
    private static final String METHOD_DURATION_REPORT_JRXML = "/reports/MethodDurationReport_pdf.jrxml";
    private static final String METHOD_DURTION_REPORT_JRXML_XLS = "/reports/MethodDurationReport_xls.jrxml";
    private JasperReport methodDurationReport;
    private JasperReport methodDurationReport_xls;

    public ReportExporter() {
        try {
            this.defaultMainReport = this.getJasperReport(DEFAULT_REPORT_JRXML);
            this.defaultMainReport_xls = this.getJasperReport(DEFAULT_REPORT_JRXML_XLS);
            this.methodDurationReport = this.getJasperReport(METHOD_DURATION_REPORT_JRXML);
            this.methodDurationReport_xls = this.getJasperReport(METHOD_DURTION_REPORT_JRXML_XLS);
        }
        catch (JRException e) {
            System.out.println((Object)e);
            LOG.error("Error compiling report", (Throwable)e);
        }
    }

    public void printReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String name, Report.EXPORT_FORMAT[] formats, Report.REPORT_TYPE type) throws JRException, IOException {
        switch (type) {
            case DEFAULT: {
                this.printDefaultReport(dataSource, jasperParameters, destinationFolder, name, formats);
                break;
            }
            case METHOD_DURATION: {
                this.printMethodDurationReport(dataSource, jasperParameters, destinationFolder, name, formats);
                break;
            }
        }
    }

    private void printDefaultReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String name, Report.EXPORT_FORMAT ... formats) throws JRException, IOException {
        this.exportReport(dataSource, jasperParameters, destinationFolder, name, Report.REPORT_TYPE.DEFAULT, formats);
    }

    private void printMethodDurationReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String name, Report.EXPORT_FORMAT ... formats) throws JRException, IOException {
        this.exportReport(dataSource, jasperParameters, destinationFolder, name, Report.REPORT_TYPE.METHOD_DURATION, formats);
    }

    private void exportReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String reportName, Report.REPORT_TYPE type, Report.EXPORT_FORMAT ... formats) throws JRException {
        destinationFolder = CommonUtils.createDefaultOutputFolder(destinationFolder);
        reportName = reportName + "_" + CommonUtils.getFormattedDate(new Date());
        block5: for (Report.EXPORT_FORMAT export_FORMAT : formats) {
            JasperReport jasperReport = this.getCompiledReport(type, export_FORMAT);
            JasperPrint jasperPrint = null;
            Collection data = ((JRBeanCollectionDataSource)dataSource).getData();
            JRBeanCollectionDataSource beanCollectionDataSource = new JRBeanCollectionDataSource(data);
            switch (export_FORMAT) {
                case HTML: {
                    jasperPrint = this.getJasperPrint(jasperReport, (JRDataSource)beanCollectionDataSource, jasperParameters);
                    this.exportHTML(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
                case PDF: {
                    jasperPrint = this.getJasperPrint(jasperReport, (JRDataSource)beanCollectionDataSource, jasperParameters);
                    this.exportPDF(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
                case XLS: {
                    jasperPrint = this.getJasperPrint(jasperReport, (JRDataSource)beanCollectionDataSource, jasperParameters);
                    this.exportXLS(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
            }
        }
    }

    private JasperReport getCompiledReport(Report.REPORT_TYPE type, Report.EXPORT_FORMAT export_FORMAT) {
        if (type == Report.REPORT_TYPE.DEFAULT) {
            if (export_FORMAT == Report.EXPORT_FORMAT.XLS) {
                return this.defaultMainReport_xls;
            }
            return this.defaultMainReport;
        }
        if (type == Report.REPORT_TYPE.METHOD_DURATION) {
            if (export_FORMAT == Report.EXPORT_FORMAT.XLS) {
                return this.methodDurationReport_xls;
            }
            return this.methodDurationReport;
        }
        return null;
    }

    private JasperPrint getJasperPrint(JasperReport jasperReport, JRDataSource dataSource, Map<String, Object> jasperParameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, jasperParameters, (JRDataSource)dataSource);
        return jasperPrint;
    }

    private JasperReport getJasperReport(String reportResource) throws JRException {
        InputStream defaultReportInputStream = ClassLoader.class.getResourceAsStream(reportResource);
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)defaultReportInputStream);
        return jasperReport;
    }

    private void exportPDF(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.PDF.toString().toLowerCase()));
    }

    private void exportHTML(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.HTML.toString().toLowerCase()));
        exporter.setParameter(JRHtmlExporterParameter.IGNORE_PAGE_MARGINS, (Object)true);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)true);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)false);
        exporter.exportReport();
    }

    private void exportXLS(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.XLS.toString().toLowerCase()));
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.exportReport();
    }
}

