/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.easetech.easytest.reports.data.Duration;
import org.easetech.easytest.reports.data.ImageBean;
import org.easetech.easytest.reports.data.MethodDurationReportBean;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.ReportTotalsBean;
import org.easetech.easytest.reports.data.TestMethodDuration;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.reports.utils.ChartUtils;
import org.easetech.easytest.util.CommonUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultPieDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportBuilder {
    private static final String CLASS_NAME = "classname";
    public static final int MAX_METHODS_PER_GRAPH = 5;
    private ReportDataContainer reportDataContainer;

    public ReportBuilder(ReportDataContainer reportDataContainer) {
        this.reportDataContainer = reportDataContainer;
    }

    public JRDataSource buildDefaultTestReport(Map<String, Object> reportParameters) {
        JRBeanCollectionDataSource defaultDataSource = new JRBeanCollectionDataSource(this.reportDataContainer.getTestResults());
        this.fillMainReportDataParameters(reportParameters, this.reportDataContainer.getClassName(), this.reportDataContainer.getMethodTestResults());
        return defaultDataSource;
    }

    public JRDataSource buildTestMethodDurationReport(Map<String, Object> reportParameters) {
        JRDataSource methodDurationDataSource = this.fillMethodDurationReportDataParametersAndGetDataSource(reportParameters, this.reportDataContainer.getClassName(), this.reportDataContainer.getMethodTestResults());
        return methodDurationDataSource;
    }

    private void fillMainReportDataParameters(Map<String, Object> reportParameters, String className, Map<String, List<TestResultBean>> methodTestResults) {
        ArrayList<ReportTotalsBean> reportTotalsBeans = new ArrayList<ReportTotalsBean>();
        for (String methodName : methodTestResults.keySet()) {
            ReportTotalsBean createTestMethodSummary = this.createTestMethodSummary(methodTestResults.get(methodName));
            createTestMethodSummary.setTotalsGraph(this.getPercentageImage(methodName, createTestMethodSummary));
            reportParameters.put(methodName, createTestMethodSummary);
            reportTotalsBeans.add(createTestMethodSummary);
        }
        ReportTotalsBean createTestClassSummary = this.createTestClassSummary(reportTotalsBeans);
        createTestClassSummary.setTotalsGraph(this.getPercentageImage(className, createTestClassSummary));
        reportParameters.put(className, createTestClassSummary);
    }

    private JRDataSource fillMethodDurationReportDataParametersAndGetDataSource(Map<String, Object> reportParameters, String className, Map<String, List<TestResultBean>> methodTestResults) {
        ArrayList<Duration> durationBeans = new ArrayList<Duration>();
        Map<String, Duration> methodDurationBeans = CommonUtils.sortByKeys(this.getMethodDurationBeans(methodTestResults));
        for (String methodName : methodDurationBeans.keySet()) {
            Duration duration = methodDurationBeans.get(methodName);
            durationBeans.add(duration);
        }
        ArrayList<MethodDurationReportBean> methodDurationReportBeans = new ArrayList<MethodDurationReportBean>();
        List partitionList = CommonUtils.partitionList(durationBeans, 5);
        for (List<Duration> list : partitionList) {
            BufferedImage methodDurationImage = this.getMethodDurationImage(className, list);
            ImageBean imageBean = new ImageBean(methodDurationImage, "", "");
            MethodDurationReportBean methodDurationBean = new MethodDurationReportBean();
            methodDurationBean.setImageBean(imageBean);
            methodDurationBean.setDurations(list);
            methodDurationReportBeans.add(methodDurationBean);
        }
        reportParameters.put(CLASS_NAME, className);
        JRBeanCollectionDataSource methodDurationDataSource = new JRBeanCollectionDataSource(methodDurationReportBeans);
        return methodDurationDataSource;
    }

    public ReportTotalsBean createTestMethodSummary(List<TestResultBean> testResultBeans) {
        ReportTotalsBean testReportTotals = new ReportTotalsBean();
        for (TestResultBean testResultBean : testResultBeans) {
            if (testResultBean.getPassed() != null && testResultBean.getPassed().booleanValue()) {
                testReportTotals.addPassed();
                continue;
            }
            if (testResultBean.getPassed() != null && !testResultBean.getPassed().booleanValue()) {
                testReportTotals.addFailed();
                continue;
            }
            if (testResultBean.getException() == null || !testResultBean.getException().booleanValue()) continue;
            testReportTotals.addException();
        }
        return testReportTotals;
    }

    public ReportTotalsBean createTestClassSummary(List<ReportTotalsBean> testReportTotalsList) {
        ReportTotalsBean testReportTotals = new ReportTotalsBean();
        testReportTotals.setItem("");
        for (ReportTotalsBean reportTotalsBean : testReportTotalsList) {
            testReportTotals.addPassed(reportTotalsBean.getPassed());
            testReportTotals.addFailed(reportTotalsBean.getFailed());
            testReportTotals.addException(reportTotalsBean.getException());
        }
        return testReportTotals;
    }

    public Map<String, Duration> getMethodDurationBeans(Map<String, List<TestResultBean>> methodTestResults) {
        HashMap<String, Duration> resultMap = new HashMap<String, Duration>();
        HashMap subResult = new HashMap();
        for (String methodName : methodTestResults.keySet()) {
            ArrayList<TestMethodDuration> subResultBeans = (ArrayList<TestMethodDuration>)subResult.get(methodName);
            if (subResultBeans == null) {
                subResultBeans = new ArrayList<TestMethodDuration>();
                subResult.put(methodName, subResultBeans);
            }
            List<TestResultBean> testResultBeans = methodTestResults.get(methodName);
            for (TestResultBean testResultBean : testResultBeans) {
                subResultBeans.addAll(testResultBean.getTestItemDurations());
            }
        }
        for (String methodName : subResult.keySet()) {
            List testMethodDurations = (List)subResult.get(methodName);
            Duration calculateTestDurationBean = this.calculateTestDurationBean(methodName, testMethodDurations);
            resultMap.put(methodName, calculateTestDurationBean);
        }
        return resultMap;
    }

    public Duration calculateTestDurationBean(String method, List<TestMethodDuration> testMethodDurations) {
        Duration resultBean = new Duration(method);
        double total = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int count = 0;
        for (TestMethodDuration testMethodDuration : testMethodDurations) {
            double timeInMs = testMethodDuration.getRoundedMsDifference().doubleValue();
            if (timeInMs > max) {
                max = timeInMs;
            }
            if (timeInMs < min) {
                min = timeInMs;
            }
            total += timeInMs;
            ++count;
        }
        resultBean.setMin(min != Double.MAX_VALUE ? (int)Math.round(min) : 0);
        resultBean.setMax(max != Double.MIN_VALUE ? (int)Math.round(max) : 0);
        resultBean.setAvg((int)Math.round(total / (double)count));
        resultBean.setCount(count);
        return resultBean;
    }

    private BufferedImage getPercentageImage(String itemName, ReportTotalsBean testReportTotals) {
        LinkedHashMap<String, Double> totalsDatasetValuesMap = new LinkedHashMap<String, Double>();
        totalsDatasetValuesMap.put("Passed (" + testReportTotals.getPercentagePassed() + "%)", testReportTotals.getPercentagePassed());
        totalsDatasetValuesMap.put("Failed (" + testReportTotals.getPercentageFailed() + "%)", testReportTotals.getPercentageFailed());
        totalsDatasetValuesMap.put("Exception (" + testReportTotals.getPercentageException() + "%)", testReportTotals.getPercentageException());
        DefaultPieDataset pieChartDataset = ChartUtils.getPieChartDataset(totalsDatasetValuesMap);
        JFreeChart pieChart = ChartUtils.getPieChart("", pieChartDataset);
        BufferedImage percentageImage = ChartUtils.getBufferedImageChartImage(pieChart, 150, 150);
        return percentageImage;
    }

    private BufferedImage getMethodDurationImage(String chartName, List<Duration> durationBeans) {
        CategoryDataset barDataset = ChartUtils.createDatasetDuration(durationBeans, "min", "max", "avg");
        CategoryDataset lineDataset = ChartUtils.createDatasetCountLine(durationBeans, "count");
        JFreeChart dualAxisChart = ChartUtils.getDualAxisChart(chartName, barDataset, lineDataset);
        BufferedImage methodDurationImage = ChartUtils.getBufferedImageChartImage(dualAxisChart, 800, 600);
        return methodDurationImage;
    }
}

