/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.reports.data.MethodUnderTestDuration;
import org.easetech.easytest.reports.data.TestResultBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDataContainer {
    private Class<?> testClass;
    private volatile List<TestResultBean> testResults = new ArrayList<TestResultBean>();
    private volatile Map<String, List<TestResultBean>> methodTestResults = new LinkedHashMap<String, List<TestResultBean>>();
    private List<MethodUnderTestDuration> durationList;

    private ReportDataContainer() {
    }

    public ReportDataContainer(Class<?> testClass) {
        this();
        this.testClass = testClass;
    }

    public void addTestResult(String method, Map<String, Object> input, Object output, Boolean passed, String result, Boolean exception, String exceptionResult) {
        TestResultBean testResultBean = new TestResultBean(method, input, output, passed, result, exception, exceptionResult, new Date());
        this.addTestResult(testResultBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestResult(TestResultBean testResult) {
        ReportDataContainer reportDataContainer = this;
        synchronized (reportDataContainer) {
            String key = testResult.getMethod();
            List<TestResultBean> list = this.methodTestResults.get(key);
            if (list == null) {
                list = new ArrayList<TestResultBean>();
                this.methodTestResults.put(key, list);
            }
            list.add(testResult);
            this.testResults.add(testResult);
        }
    }

    public List<TestResultBean> getTestResults() {
        return this.testResults;
    }

    public Map<String, List<TestResultBean>> getMethodTestResults() {
        return this.methodTestResults;
    }

    public String getClassName() {
        return this.getTestClass().getName();
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public List<MethodUnderTestDuration> getDurationList() {
        return this.durationList;
    }

    public void setDurationList(List<MethodUnderTestDuration> durationList) {
        this.durationList = durationList;
    }

    public String toString() {
        return "ReportDataContainer [testClass=" + this.testClass + ", testResults=" + this.testResults + ", methodTestResults=" + this.methodTestResults + ", durationList=" + this.durationList + "]";
    }
}

