/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.easetech.easytest._1.Entry;
import org.easetech.easytest._1.InputData;
import org.easetech.easytest._1.InputTestData;
import org.easetech.easytest._1.ObjectFactory;
import org.easetech.easytest._1.OutputData;
import org.easetech.easytest._1.TestMethod;
import org.easetech.easytest._1.TestRecord;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(XMLDataLoader.class);
    private static final String RECORD_POSITION = "recordPosition";

    @Override
    public Map<String, List<Map<String, Object>>> loadData(Resource resource) {
        Map<String, List<Map<String, Object>>> result = null;
        try {
            result = this.load(resource.getInputStream());
        }
        catch (IOException e) {
            LOG.error("IOException occured while trying to Load the resource {} . Moving to the next resource.", (Object)resource.getResourceName(), (Object)e);
        }
        if (result != null) {
            LOG.debug("Loading data from resource {} succedded and the data loaded is {}", (Object)resource.getResourceName(), result);
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> load(InputStream xmlFile) throws IOException {
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        JAXBContext context = this.getJAXBContext();
        try {
            if (context != null) {
                Unmarshaller unmarshaller = context.createUnmarshaller();
                InputTestData testData = (InputTestData)unmarshaller.unmarshal(xmlFile);
                this.convertFromInputTestData(testData, data);
            }
        }
        catch (JAXBException e) {
            LOG.error("JAXBException occured while trying to unmarshal the data.", (Throwable)e);
            throw new RuntimeException("JAXBException occured while trying to unmarshal the data.", e);
        }
        return data;
    }

    private void convertFromInputTestData(InputTestData source, Map<String, List<Map<String, Object>>> destination) {
        List<TestMethod> testMethods = source.getTestMethod();
        for (TestMethod method : testMethods) {
            InputData defaultInputData = method.getInputData();
            List<Map<String, Object>> testMethodData = this.convertFromLIstOfTestRecords(method.getTestRecord(), defaultInputData);
            LOG.debug("Read record for method {} and the data read is {}", (Object)method.getName(), testMethodData);
            destination.put(method.getName(), testMethodData);
        }
    }

    private List<Map<String, Object>> convertFromLIstOfTestRecords(List<TestRecord> dataRecords, InputData defaultInputData) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (dataRecords != null) {
            for (TestRecord record : dataRecords) {
                Map<String, Object> singleTestData = this.convertFromListOfEntry(record.getInputData().getEntry(), defaultInputData != null ? defaultInputData.getEntry() : null);
                singleTestData.put(RECORD_POSITION, record.getId());
                result.add(singleTestData);
            }
        }
        return result;
    }

    Map<String, Object> convertFromListOfEntry(List<Entry> testEntries, List<Entry> defaultEntries) {
        HashMap<String, Object> testData = new HashMap<String, Object>();
        if (defaultEntries != null) {
            for (Entry defaultEntry : defaultEntries) {
                testData.put(defaultEntry.getKey(), defaultEntry.getValue());
            }
        }
        if (testEntries != null) {
            for (Entry entry : testEntries) {
                testData.put(entry.getKey(), entry.getValue());
            }
        }
        return testData;
    }

    private JAXBContext getJAXBContext() {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            LOG.error("Error occured while creating JAXB COntext.", (Throwable)e);
            throw new RuntimeException("Error occurred while creating JAXB Context.", e);
        }
        return context;
    }

    @Override
    public void writeData(Resource resource, Map<String, List<Map<String, Object>>> actualData, String ... methodNames) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(resource.getInputStream());
            Binder binder = this.getJAXBContext().createBinder(Node.class);
            binder.setProperty("jaxb.formatted.output", (Object)true);
            InputTestData testData = (InputTestData)binder.unmarshal((Object)document);
            if (methodNames == null || methodNames.length == 0) {
                this.updateTestMethods(testData, null, actualData);
            } else {
                for (String methodName : methodNames) {
                    this.updateTestMethods(testData, methodName, actualData);
                }
            }
            binder.updateXML((Object)testData);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(document), new StreamResult(resource.getOutputStream()));
        }
        catch (ParserConfigurationException e) {
            LOG.error("Ignoring the write operation as ParserConfigurationException occured while parsing the file : " + resource.getResourceName(), (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error("Ignoring the write operation as SAXException occured while parsing the file : " + resource.getResourceName(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Ignoring the write operation as IOException occured while parsing the file : " + resource.getResourceName(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error("Ignoring the write operation as JAXBException occured while parsing the file : " + resource.getResourceName(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error("Ignoring the write operation as TransformerException occured while parsing the file : " + resource.getResourceName(), (Throwable)e);
        }
    }

    private void updateTestMethods(InputTestData inputTestData, String methodToWriteDataFor, Map<String, List<Map<String, Object>>> actualData) {
        Boolean isMethodNameAbsent = methodToWriteDataFor == null || methodToWriteDataFor.length() <= 0;
        for (String methodName : actualData.keySet()) {
            if (!isMethodNameAbsent.booleanValue() && !methodName.equals(methodToWriteDataFor)) continue;
            List<Map<String, Object>> testRecords = actualData.get(methodName);
            block1: for (Map<String, Object> testRecord : testRecords) {
                OutputData outputData;
                List<TestRecord> originalTestRecords;
                Boolean outputDataAdded = false;
                if (testRecord.containsKey("ActualResult")) {
                    for (TestMethod testMethod : inputTestData.getTestMethod()) {
                        originalTestRecords = testMethod.getTestRecord();
                        for (TestRecord originalTestRecord : originalTestRecords) {
                            if (!originalTestRecord.getId().equals(testRecord.get(RECORD_POSITION))) continue;
                            outputData = new OutputData();
                            Entry outputEntry = new Entry();
                            outputEntry.setKey("ActualResult");
                            outputEntry.setValue(testRecord.get("ActualResult").toString());
                            Entry durationEntry = new Entry();
                            durationEntry.setKey("Duration(ms)");
                            durationEntry.setValue(testRecord.get("Duration(ms)").toString());
                            outputData.getEntry().add(outputEntry);
                            outputData.getEntry().add(durationEntry);
                            if (testRecord.get("TestStatus") != null) {
                                Entry statusEntry = new Entry();
                                statusEntry.setKey("TestStatus");
                                statusEntry.setValue(testRecord.get("TestStatus").toString());
                                outputData.getEntry().add(statusEntry);
                            }
                            originalTestRecord.setOutputData(outputData);
                            outputDataAdded = true;
                            break;
                        }
                        if (!outputDataAdded.booleanValue()) continue;
                        continue block1;
                    }
                    continue;
                }
                block4: for (TestMethod testMethod : inputTestData.getTestMethod()) {
                    originalTestRecords = testMethod.getTestRecord();
                    for (TestRecord originalTestRecord : originalTestRecords) {
                        if (!originalTestRecord.getId().equals(testRecord.get(RECORD_POSITION))) continue;
                        outputData = new OutputData();
                        Entry durationEntry = new Entry();
                        durationEntry.setKey("Duration(ms)");
                        durationEntry.setValue(testRecord.get("Duration(ms)").toString());
                        outputData.getEntry().add(durationEntry);
                        originalTestRecord.setOutputData(outputData);
                        outputDataAdded = true;
                        continue block4;
                    }
                }
            }
        }
    }
}

