/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import junit.framework.Assert;
import org.easetech.easytest.loader.CSVDataLoader;
import org.easetech.easytest.loader.ExcelDataLoader;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.loader.LoaderType;
import org.easetech.easytest.loader.XMLDataLoader;

public class LoaderFactory {
    public static Loader getLoader(LoaderType loaderType) {
        Loader loader = null;
        if (LoaderType.CSV.equals((Object)loaderType)) {
            loader = new CSVDataLoader();
        } else if (LoaderType.EXCEL.equals((Object)loaderType)) {
            loader = new ExcelDataLoader();
        } else if (LoaderType.XML.equals((Object)loaderType)) {
            loader = new XMLDataLoader();
        } else {
            Assert.fail((String)"The framework currently does not support the specified Loader type. You can provide the custom Loader by choosing LoaderType.CUSTOM in TestData annotation and providing your custom loader using DataLoader annotation.");
        }
        return loader;
    }
}

