/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(ExcelDataLoader.class);
    private transient Map<String, List<Map<String, Object>>> data = null;

    public ExcelDataLoader() {
    }

    public ExcelDataLoader(InputStream excelInputStream) throws IOException {
        this.data = this.loadFromSpreadsheet(excelInputStream);
    }

    public Map<String, List<Map<String, Object>>> getData() {
        return this.data;
    }

    @Override
    public Map<String, List<Map<String, Object>>> loadData(Resource resource) {
        LOG.debug("Trying to load the data for resource :" + resource.getResourceName());
        Map<String, List<Map<String, Object>>> result = null;
        try {
            result = this.loadFromSpreadsheet(resource.getInputStream());
        }
        catch (IOException e) {
            LOG.error("IOException occured while trying to Load the resource {} . Moving to the next resource.", (Object)resource.getResourceName(), (Object)e);
        }
        if (result != null) {
            LOG.debug("Loading data from resource {} succedded and the data loaded is {}", (Object)resource.getResourceName(), result);
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> loadFromSpreadsheet(InputStream excelFile) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(excelFile);
        this.data = new HashMap<String, List<Map<String, Object>>>();
        HSSFSheet sheet = workbook.getSheetAt(0);
        LOG.debug("Sheet {} is being read", (Object)sheet);
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        HashMap<Integer, Object> tempData = new HashMap<Integer, Object>();
        ArrayList<LinkedHashMap<String, Object>> dataValues = null;
        LinkedHashMap<String, Object> actualData = new LinkedHashMap<String, Object>();
        for (Row row : sheet) {
            boolean keyRow = this.isKeyRow(row, workbook);
            actualData = this.initializeRowData(row, workbook, actualData);
            StringBuffer debugInfo = new StringBuffer("Row data being read is ");
            for (Cell cell : row) {
                Object cellData = this.objectFrom(workbook, cell);
                debugInfo.append(":" + cellData);
                if (cell.getColumnIndex() == 0 && keyRow) {
                    dataValues = new ArrayList<LinkedHashMap<String, Object>>();
                    finalData.put(cellData.toString().trim(), dataValues);
                    continue;
                }
                if (keyRow) {
                    tempData.put(cell.getColumnIndex(), cellData);
                    continue;
                }
                if (tempData.get(cell.getColumnIndex()) == null) continue;
                actualData.put(tempData.get(cell.getColumnIndex()).toString(), cellData);
            }
            LOG.debug(debugInfo.toString());
            if (keyRow) continue;
            dataValues.add(actualData);
        }
        return finalData;
    }

    private LinkedHashMap<String, Object> initializeRowData(Row row, HSSFWorkbook workbook, LinkedHashMap<String, Object> actualData) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.isKeyRow(row, workbook).booleanValue()) {
            actualData = new LinkedHashMap();
            for (Cell cell : row) {
                Object cellData;
                if (cell.getColumnIndex() == 0 || (cellData = this.objectFrom(workbook, cell)) == null) continue;
                actualData.put(cellData.toString(), null);
            }
        } else {
            for (String key : actualData.keySet()) {
                result.put(key, null);
            }
            return result;
        }
        return actualData;
    }

    private Boolean isKeyRow(Row row, HSSFWorkbook workbook) {
        Boolean result = false;
        Cell cell = row.getCell(0);
        Object cellData = this.objectFrom(workbook, cell);
        if (cellData != null && !"".equals(cellData)) {
            result = true;
        }
        return result;
    }

    private Map<String, Object> nullValueMap(Map<Integer, Object> tempObject) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (tempObject.isEmpty()) {
            return result;
        }
        Iterator<Integer> tempObjItr = tempObject.keySet().iterator();
        while (tempObjItr.hasNext()) {
            result.put(tempObject.get(tempObjItr.next()).toString(), null);
        }
        return result;
    }

    private Object objectFrom(HSSFWorkbook workbook, Cell cell) {
        Object cellValue = null;
        if (cell == null || cell.getCellType() == 3) {
            cellValue = null;
        } else if (cell.getCellType() == 1) {
            cellValue = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 0) {
            cellValue = this.getNumericCellValue(cell);
        } else if (cell.getCellType() == 4) {
            cellValue = cell.getBooleanCellValue();
        } else if (cell.getCellType() == 2) {
            cellValue = this.evaluateCellFormula(workbook, cell);
        }
        return cellValue;
    }

    private Object getNumericCellValue(Cell cell) {
        Object cellValue;
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            cellValue = new Date(cell.getDateCellValue().getTime());
        } else {
            cellValue = cell.getNumericCellValue();
            if (cellValue != null && cellValue.toString().endsWith(".0")) {
                cellValue = cellValue.toString().replace(".0", "");
            }
        }
        return cellValue;
    }

    private Object evaluateCellFormula(HSSFWorkbook workbook, Cell cell) {
        HSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        Object result = null;
        if (cellValue.getCellType() == 4) {
            result = cellValue.getBooleanValue();
        } else if (cellValue.getCellType() == 0) {
            result = cellValue.getNumberValue();
        } else if (cellValue.getCellType() == 1) {
            result = cellValue.getStringValue();
        }
        return result;
    }

    @Override
    public void writeData(Resource resource, Map<String, List<Map<String, Object>>> actualData, String ... methodNames) {
        try {
            if (methodNames == null || methodNames.length == 0) {
                this.writeFullDataToSpreadsheet(resource.getOutputStream(), actualData);
            } else {
                for (String methodName : methodNames) {
                    this.writeDataToSpreadsheet(resource, methodName, actualData);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to write data to file {} . An I/O Exception occured.", (Object)resource.getResourceName(), (Object)e);
        }
    }

    private void writeDataToSpreadsheet(Resource resource, String methodNameForDataLoad, Map<String, List<Map<String, Object>>> data) throws IOException {
        Workbook workbook;
        LOG.debug("writeDataToSpreadsheet started" + resource.toString() + data);
        try {
            workbook = WorkbookFactory.create((POIFSFileSystem)new POIFSFileSystem(resource.getInputStream()));
        }
        catch (Exception e) {
            LOG.error("Error creating WorkbookFactory for resource " + resource.toString(), (Throwable)e);
            throw new IOException();
        }
        Sheet sheet = workbook.getSheetAt(0);
        Integer recordNum = this.getMethodRowNumFromExcel(sheet, methodNameForDataLoad);
        if (recordNum == null) {
            LOG.error("Method doesn't exist in the excel:" + methodNameForDataLoad);
            return;
        }
        short columnNum = sheet.getRow(recordNum.intValue()).getLastCellNum();
        int rowNum = 0;
        boolean isActualResultHeaderWritten = false;
        boolean isTestDurationHeaderWritten = false;
        boolean isHeaderRowNumIncremented = false;
        for (Map<String, Object> methodData : data.get(methodNameForDataLoad)) {
            ++rowNum;
            Object testDuration = methodData.get("Duration(ms)");
            if (testDuration != null) {
                if (!isTestDurationHeaderWritten && recordNum != null) {
                    this.writeDataToCell(sheet, recordNum, columnNum, "Duration(ms)");
                    rowNum += recordNum.intValue();
                    isTestDurationHeaderWritten = true;
                }
                if (isTestDurationHeaderWritten) {
                    LOG.debug("testDuration:" + testDuration.toString());
                    this.writeDataToCell(sheet, rowNum, columnNum, testDuration.toString());
                }
            }
            if (!isHeaderRowNumIncremented && (isTestDurationHeaderWritten || isActualResultHeaderWritten)) {
                isHeaderRowNumIncremented = true;
            }
            Object actualResult = methodData.get("ActualResult");
            Object testStatus = methodData.get("TestStatus");
            if (actualResult == null) continue;
            if (!isActualResultHeaderWritten && recordNum != null) {
                this.writeDataToCell(sheet, recordNum, columnNum + 1, "ActualResult");
                if (testStatus != null) {
                    this.writeDataToCell(sheet, recordNum, columnNum + 2, "TestStatus");
                }
                isActualResultHeaderWritten = true;
            }
            LOG.debug("rowNum:" + rowNum);
            if (!isActualResultHeaderWritten) continue;
            LOG.debug("actualResult:" + actualResult.toString());
            actualResult = this.trimActualResult(actualResult.toString());
            this.writeDataToCell(sheet, rowNum, columnNum + 1, actualResult.toString());
            if (testStatus == null) continue;
            Object expectedResult = methodData.get("ExpectedResult");
            testStatus = expectedResult.toString().equals(actualResult.toString()) ? "PASSED" : "FAILED";
            LOG.debug("testStatus:" + testStatus.toString());
            this.writeDataToCell(sheet, rowNum, columnNum + 2, testStatus.toString());
        }
        workbook.write(resource.getOutputStream());
        LOG.debug("writeDataToSpreadsheet finished");
    }

    private Object trimActualResult(String stringValue) {
        if (stringValue.length() > 30000) {
            stringValue = stringValue.substring(0, 30000);
        }
        return stringValue;
    }

    private Integer getMethodRowNumFromExcel(Sheet sheet, String methodName) {
        Integer rowNum = null;
        for (Row row : sheet) {
            String cellData;
            Cell cell = row.getCell(0);
            if (cell == null || (cellData = cell.getStringCellValue()) == null || !methodName.equals(cellData.trim())) continue;
            rowNum = cell.getRow().getRowNum();
            break;
        }
        LOG.debug("getMethodRowNumFromExcel finished:" + methodName + rowNum);
        return rowNum;
    }

    private void writeDataToCell(Sheet sheet, int rowNum, int columnNum, Object value) {
        Cell cell;
        LOG.debug("writeDataToCell started:" + sheet.getSheetName() + ",rowNum:" + rowNum + ",columnNum:" + columnNum + ",value:" + value);
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            row = sheet.createRow(rowNum);
        }
        if ((cell = row.getCell(columnNum)) == null) {
            int lastColumn = row.getLastCellNum();
            if (lastColumn < 0) {
                lastColumn = 0;
            }
            if (lastColumn > columnNum) {
                lastColumn = columnNum;
            }
            for (int i = lastColumn; i <= columnNum; ++i) {
                cell = row.createCell(i);
            }
        }
        if (value instanceof String) {
            cell.setCellType(1);
            cell.setCellValue((String)this.trimActualResult(value.toString()));
        } else if (value instanceof Double) {
            cell.setCellType(0);
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            cell.setCellType(0);
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Long) {
            cell.setCellType(0);
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Float) {
            cell.setCellType(0);
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value != null) {
            cell.setCellType(1);
            cell.setCellValue((String)this.trimActualResult(value.toString()));
        }
    }

    private void writeFullDataToSpreadsheet(OutputStream fos, Map<String, List<Map<String, Object>>> data) throws IOException {
        LOG.debug("writeFullDataToSpreadsheet started" + data);
        HSSFWorkbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        int rowNum = sheet.getLastRowNum();
        LOG.debug("sheet.getLastRowNum()" + sheet.getLastRowNum());
        for (String methodName : data.keySet()) {
            boolean isHeaderWritten = false;
            LinkedHashMap<String, Integer> parameterIndexMap = new LinkedHashMap<String, Integer>();
            for (Map<String, Object> methodData : data.get(methodName)) {
                int columnIndex;
                LOG.debug("methodData.keySet().size" + methodData.keySet().size());
                LOG.debug("methodData" + methodData);
                if (!isHeaderWritten) {
                    columnIndex = 0;
                    this.writeDataToCell(sheet, rowNum, columnIndex++, methodName);
                    for (String parameterName : methodData.keySet()) {
                        this.writeDataToCell(sheet, rowNum, columnIndex, parameterName);
                        parameterIndexMap.put(parameterName, columnIndex);
                        ++columnIndex;
                    }
                    ++rowNum;
                    isHeaderWritten = true;
                }
                if (!isHeaderWritten) continue;
                columnIndex = 0;
                this.writeDataToCell(sheet, rowNum, columnIndex++, null);
                for (String parameter : methodData.keySet()) {
                    this.writeDataToCell(sheet, rowNum, (Integer)parameterIndexMap.get(parameter), methodData.get(parameter));
                }
                ++rowNum;
            }
        }
        workbook.write(fos);
        LOG.debug("writeFullDataToSpreadsheet finished");
    }
}

