/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyParamSignature {
    private final Boolean isGenericParameter;
    private final Class<?> genericParameterArgType;
    private final Class<?> parameterType;
    private final Annotation[] parameterAnnotations;

    public static ArrayList<EasyParamSignature> signatures(Method method) {
        return EasyParamSignature.signatures(method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    public static List<EasyParamSignature> signatures(Constructor<?> constructor) {
        return EasyParamSignature.signatures(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    private static ArrayList<EasyParamSignature> signatures(Type[] parameterTypes, Annotation[][] parameterAnnotations) {
        ArrayList<EasyParamSignature> sigs = new ArrayList<EasyParamSignature>();
        Class parameterType = null;
        Class genericParameterArgType = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type genericParameterType = parameterTypes[i];
            if (ParameterizedType.class.isAssignableFrom(genericParameterType.getClass())) {
                Type[] parameterArgTypes;
                ParameterizedType aType = (ParameterizedType)genericParameterType;
                parameterType = (Class)aType.getRawType();
                for (Type parameterArgType : parameterArgTypes = aType.getActualTypeArguments()) {
                    genericParameterArgType = (Class)parameterArgType;
                }
            } else {
                parameterType = (Class)genericParameterType;
            }
            sigs.add(new EasyParamSignature(parameterType, parameterAnnotations[i], genericParameterArgType));
        }
        return sigs;
    }

    private EasyParamSignature(Class<?> parameterType, Annotation[] parameterAnnotations, Class<?> genericParameterArgType) {
        this.parameterType = parameterType;
        this.parameterAnnotations = parameterAnnotations;
        if (genericParameterArgType != null) {
            this.isGenericParameter = true;
            this.genericParameterArgType = genericParameterArgType;
        } else {
            this.isGenericParameter = false;
            this.genericParameterArgType = null;
        }
    }

    public boolean canAcceptType(Class<?> candidate) {
        return this.parameterType.isAssignableFrom(candidate);
    }

    public Boolean getIsGenericParameter() {
        return this.isGenericParameter;
    }

    public Class<?> getGenericParameterArgType() {
        return this.genericParameterArgType;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public Annotation[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public boolean canAcceptArrayType(Class<?> type) {
        return type.isArray() && this.canAcceptType(type.getComponentType());
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }

    public <T extends Annotation> T findDeepAnnotation(Class<T> annotationType) {
        Annotation[] annotations2 = this.parameterAnnotations;
        return this.findDeepAnnotation(annotations2, annotationType, 3);
    }

    private <T extends Annotation> T findDeepAnnotation(Annotation[] annotations, Class<T> annotationType, int depth) {
        if (depth == 0) {
            return null;
        }
        for (Annotation each : annotations) {
            if (annotationType.isInstance(each)) {
                return (T)((Annotation)annotationType.cast(each));
            }
            T candidate = this.findDeepAnnotation(each.annotationType().getAnnotations(), annotationType, depth - 1);
            if (candidate == null) continue;
            return (T)((Annotation)annotationType.cast(candidate));
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation each : this.getParameterAnnotations()) {
            if (!annotationType.isInstance(each)) continue;
            return (T)((Annotation)annotationType.cast(each));
        }
        return null;
    }
}

