/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.interceptor;

import java.lang.reflect.Method;
import java.util.Observable;
import junit.framework.Assert;
import org.easetech.easytest.interceptor.MethodIntercepter;
import org.easetech.easytest.reports.data.MethodUnderTestDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonProxyInterceptor
extends Observable {
    protected static final Logger LOG = LoggerFactory.getLogger(CommonProxyInterceptor.class);
    private MethodIntercepter userIntercepter;
    private Object targetInstance;
    private Long expectedRunTime;

    public MethodIntercepter getUserIntercepter() {
        return this.userIntercepter;
    }

    public void setUserIntercepter(MethodIntercepter userIntercepter) {
        this.userIntercepter = userIntercepter;
    }

    public Object getTargetInstance() {
        return this.targetInstance;
    }

    public void setTargetInstance(Object targetInstance) {
        this.targetInstance = targetInstance;
    }

    public Long getExpectedRunTime() {
        return this.expectedRunTime;
    }

    public void setExpectedRunTime(Long expectedRunTime) {
        this.expectedRunTime = expectedRunTime;
    }

    public Long getExpectedTimeInNano(Long timeInMillis) {
        Long result = null;
        Long nanoBase = 1000000L;
        if (timeInMillis != null && timeInMillis != 0L && timeInMillis != Long.MAX_VALUE) {
            if (nanoBase > Long.MAX_VALUE / timeInMillis) {
                Assert.fail((String)("EasyTest tries to convert the time (specified in Millisecond using Duration annotation) into nano seconds for precise comparisons.But in this particular case, you specified a value that would ultimately overflow and will not fit in the long datatype. The value is : " + timeInMillis + "(ms). Please specify a smaller time unit."));
            } else {
                result = timeInMillis * nanoBase;
            }
        }
        return result;
    }

    public void compareTime(Long timeTakenInNanos, Method method, MethodUnderTestDuration durationBean) {
        Long expectedTimeInNano = this.getExpectedTimeInNano(this.getExpectedRunTime());
        Long expectedTimeInMillis = 0L;
        Long timeTakenInMicros = timeTakenInNanos / 1000L;
        Long timeTakenInMillis = timeTakenInNanos / 1000L / 1000L;
        if (expectedTimeInNano != null && timeTakenInNanos > expectedTimeInNano) {
            expectedTimeInMillis = expectedTimeInNano / 1000L / 1000L;
            Long expectedTimeinMicros = expectedTimeInNano / 1000L;
            Assert.fail((String)("Total time taken by method " + method.getName() + " (" + timeTakenInNanos + " nanosec/" + timeTakenInMicros + " microsec/" + timeTakenInMillis + " millisec) is greater than the " + "expected time(" + expectedTimeInNano + " nenosec/" + expectedTimeinMicros + " microsec/" + expectedTimeInMillis + " millisec)"));
        } else {
            System.out.println("Method " + method.getName() + " on " + this.getTargetInstance().getClass() + " took " + timeTakenInNanos + " nanosec/" + timeTakenInMicros + " microsec/" + timeTakenInMillis + " millisec");
            LOG.debug("Method " + method.getName() + " on " + this.getTargetInstance().getClass() + " took " + timeTakenInNanos + " nanosec/" + timeTakenInMicros + " microsec/" + timeTakenInMillis + " millisec");
        }
        durationBean.setActualDurationinMillis(timeTakenInMillis);
        durationBean.setExpectedDurationinMillis(expectedTimeInMillis);
        this.notifyObservers(durationBean);
    }

    public Object intercept(Method method, Object[] args) throws Throwable {
        Long startTime = System.nanoTime();
        Object result = this.getUserIntercepter().intercept(method, this.getTargetInstance(), args);
        Long timeTaken = System.nanoTime() - startTime;
        MethodUnderTestDuration durationBean = this.getMethodDurationBean(method, args, result);
        this.compareTime(timeTaken, method, durationBean);
        return result;
    }

    private MethodUnderTestDuration getMethodDurationBean(Method method, Object[] args, Object result) {
        MethodUnderTestDuration durationBean = new MethodUnderTestDuration();
        durationBean.setClassUnderTest(this.getTargetInstance().getClass());
        durationBean.setMethodUnderTest(method);
        durationBean.setMethodArguments(args);
        durationBean.setMethodResult(result);
        return durationBean;
    }
}

