/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.AbstractConverter;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.converter.ConverterSupport;
import org.easetech.easytest.converter.ParamAwareConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final Class<?> parameterType;
    private final String paramName;
    private final Boolean convertEmptyToNull;
    private final DateTimeFormat dateTimeFormat;
    private static final Logger LOG = LoggerFactory.getLogger(UserDefinedConverter.class);

    public UserDefinedConverter(Class<?> parameterType, String paramName, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.parameterType = parameterType;
        this.paramName = paramName;
        this.convertEmptyToNull = convertEmptyToNull;
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        ArrayList<PotentialAssignment> potentialAssignments = null;
        LOG.debug("Trying to find a registerd converter for class {}", this.parameterType);
        Converter<?> converter = ConverterManager.findConverter(this.parameterType);
        if (converter != null) {
            if (converter instanceof AbstractConverter) {
                ConverterSupport converterSupport = new ConverterSupport();
                converterSupport.setConvertEmptyToNull(this.convertEmptyToNull);
                converterSupport.setDateTimeFormat(this.dateTimeFormat);
                converterSupport.setParamName(this.paramName);
                ((AbstractConverter)converter).setConverterSupport(converterSupport);
            }
            potentialAssignments = new ArrayList<PotentialAssignment>();
            LOG.debug("Converter for class {} found.", this.parameterType);
            for (Map<String, Object> object : convertFrom) {
                Object value = null;
                value = converter instanceof ParamAwareConverter ? ((ParamAwareConverter)converter).convert(object, this.paramName) : converter.convert(object);
                potentialAssignments.add(PotentialAssignment.forValue((String)"", value));
            }
        }
        return potentialAssignments;
    }
}

