/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardObjectConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final Class<?> parameterType;
    private final String paramName;
    private final Boolean convertEmptyToNull;
    private final DateTimeFormat dateTimeFormat;
    private static final Logger LOG = LoggerFactory.getLogger(StandardObjectConverter.class);

    public StandardObjectConverter(Class<?> parameterType, String paramName, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.parameterType = parameterType;
        this.paramName = paramName;
        this.convertEmptyToNull = convertEmptyToNull;
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        LOG.debug("Trying to convert the data to a standard Object instance using {}", (Object)StandardObjectConverter.class.getSimpleName());
        ArrayList<PotentialAssignment> potentialAssignments = null;
        if (GeneralUtil.isStandardObjectInstance(this.parameterType)) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            for (Map<String, Object> object : convertFrom) {
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)GeneralUtil.convertToTargetType(this.parameterType, object.get(this.paramName), this.convertEmptyToNull, this.dateTimeFormat)));
            }
        }
        return potentialAssignments;
    }
}

