/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.internal.EasyParamSignature;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardObjectCollectionConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final Collection collection;
    private final EasyParamSignature signature;
    private final String paramName;
    private final Boolean convertEmptyToNull;
    private final DateTimeFormat dateTimeFormat;
    private static final Logger LOG = LoggerFactory.getLogger(StandardObjectCollectionConverter.class);

    public StandardObjectCollectionConverter(Collection collection, EasyParamSignature signature, String paramName, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.collection = collection;
        this.signature = signature;
        this.paramName = paramName;
        this.convertEmptyToNull = convertEmptyToNull;
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        Class<Object> genericType;
        ArrayList<PotentialAssignment> potentialAssignments = null;
        Class clazz = genericType = this.signature.getIsGenericParameter() != false ? this.signature.getGenericParameterArgType() : Object.class;
        if (GeneralUtil.isStandardObjectInstance(genericType)) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            LOG.debug("parameter to the collection is a Standard Java Class {} . Using Internal Editors to resolve values", genericType);
            for (Map<String, Object> object : convertFrom) {
                String[] strValues = ((String)object.get(this.paramName)).split(":");
                for (int i = 0; i < strValues.length; ++i) {
                    this.collection.add(GeneralUtil.convertToTargetType(genericType, strValues[i], this.convertEmptyToNull, this.dateTimeFormat));
                }
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)this.collection));
            }
        }
        return potentialAssignments;
    }
}

