/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.internal.EasyParamSignature;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorCollectionConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final EasyParamSignature signature;
    private final String paramName;
    private final Collection collection;
    private static final Logger LOG = LoggerFactory.getLogger(PropertyEditorCollectionConverter.class);

    public PropertyEditorCollectionConverter(EasyParamSignature signature, String paramName, Collection collection) {
        this.signature = signature;
        this.paramName = paramName;
        this.collection = collection;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        ArrayList<PotentialAssignment> potentialAssignments = null;
        Class<Object> genericType = this.signature.getIsGenericParameter() != false ? this.signature.getGenericParameterArgType() : Object.class;
        PropertyEditor editor = PropertyEditorManager.findEditor(genericType);
        if (editor != null) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            LOG.debug("Editor for class {} found", genericType);
            for (Map<String, Object> object : convertFrom) {
                String strValue = null;
                strValue = this.paramName != null && !"".equals(this.paramName) ? GeneralUtil.getStringValue(this.paramName, object) : GeneralUtil.getStringValue(genericType.getSimpleName(), object);
                if (strValue != null) {
                    String[] values = strValue.split(":");
                    for (int i = 0; i < values.length; ++i) {
                        editor.setAsText(values[i]);
                        if (editor.getValue() == null) continue;
                        this.collection.add(editor.getValue());
                    }
                }
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)this.collection));
            }
        }
        return potentialAssignments;
    }
}

