/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private static final Logger LOG = LoggerFactory.getLogger(MapConverter.class);
    private final Class<?> mapType;

    public MapConverter(Class<?> mapType) {
        this.mapType = mapType;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        ArrayList<PotentialAssignment> potentialAssignments = null;
        if (Map.class.isAssignableFrom(this.mapType)) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            for (Map<String, Object> map : convertFrom) {
                Map dataValues;
                if (this.mapType.isInterface()) {
                    potentialAssignments.add(PotentialAssignment.forValue((String)"", map));
                    continue;
                }
                try {
                    dataValues = (Map)this.mapType.newInstance();
                }
                catch (Exception e) {
                    LOG.error("Exception occured while trying to convert the data to Map(using newInstance() method). The type of Map passed as input parameter is :" + this.mapType, (Throwable)e);
                    throw new RuntimeException(e);
                }
                dataValues.putAll(map);
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)dataValues));
            }
        }
        return potentialAssignments;
    }
}

