/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.HashSet;
import java.util.Set;
import org.easetech.easytest.converter.AbstractConverter;
import org.easetech.easytest.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterManager {
    public static final InheritableThreadLocal<Set<Converter>> converters = new InheritableThreadLocal();

    public static Converter<?> findConverter(Class<?> targetType) {
        Set cnvrtrs = (Set)converters.get();
        Converter result = null;
        if (cnvrtrs != null) {
            for (Converter converter : cnvrtrs) {
                if (!converter.convertTo().equals(targetType)) continue;
                result = converter;
                break;
            }
        }
        return result;
    }

    public static void registerConverter(Class converterClass) {
        HashSet<Converter> cnvrtrs = (HashSet<Converter>)converters.get();
        if (cnvrtrs == null) {
            cnvrtrs = new HashSet<Converter>();
        }
        if (converterClass != null && Converter.class.isAssignableFrom(converterClass)) {
            Converter converter = null;
            try {
                converter = (Converter)converterClass.newInstance();
                cnvrtrs.add(converter);
                converters.set(cnvrtrs);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("InstantiationException occured while trying to register a converter with class : " + converterClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("IllegalAccessException occured while trying to register a converter with class : " + converterClass, e);
            }
        } else {
            throw new RuntimeException("Could not register the converter for  " + converterClass + " . Either the passed argument is NULL or the passed class does not extend the " + AbstractConverter.class.getSimpleName() + " abstract class or implement the " + Converter.class.getSimpleName() + " interface.");
        }
    }

    public static void cleanConverters() {
        converters.remove();
    }
}

