/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.converter.ParamConstructorConverter;
import org.easetech.easytest.converter.PropertyEditorCollectionConverter;
import org.easetech.easytest.converter.StandardObjectCollectionConverter;
import org.easetech.easytest.converter.UserDefinedCollectionConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.internal.EasyParamSignature;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final EasyParamSignature signature;
    private final String paramName;
    private final Collection collection;
    private static final String STND_OBJ_COLLECTION_CONVERTER = "stdObjCollectionConverter";
    private static final String PROPERTY_EDITOR_COLLECTION_CONVERTER = "propertyEditorCollectionConverter";
    private static final String USER_DEFINED_COLLECTION_CONVERTER = "userDefinedCollectionConverter";
    private static final String PARAM_CONSTRUCTOR_CONVERTER = "paramConstructorConverter";
    private final Map<String, BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>>> converters = new LinkedHashMap<String, BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>>>();
    private static final Logger LOG = LoggerFactory.getLogger(CollectionConverter.class);

    public CollectionConverter(EasyParamSignature signature, String paramName, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.signature = signature;
        this.paramName = paramName;
        Class genericType = signature.getIsGenericParameter() != false ? signature.getGenericParameterArgType() : Object.class;
        this.collection = CollectionConverter.getCollectionInstance(signature.getParameterType(), genericType);
        this.converters.put(STND_OBJ_COLLECTION_CONVERTER, new StandardObjectCollectionConverter(this.collection, signature, paramName, convertEmptyToNull, dateTimeFormat));
        this.converters.put(PROPERTY_EDITOR_COLLECTION_CONVERTER, new PropertyEditorCollectionConverter(signature, paramName, this.collection));
        this.converters.put(USER_DEFINED_COLLECTION_CONVERTER, new UserDefinedCollectionConverter(signature, paramName, this.collection));
        this.converters.put(PARAM_CONSTRUCTOR_CONVERTER, new ParamConstructorConverter(genericType, paramName, this.collection, convertEmptyToNull, dateTimeFormat));
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        List<Object> potentialAssignments;
        block6: {
            potentialAssignments = null;
            if (!Collection.class.isAssignableFrom(this.signature.getParameterType())) break block6;
            if (this.collection == null) {
                Assert.fail((String)("Unable to identify the Collection with Class :" + this.signature.getParameterType()));
            }
            potentialAssignments = new ArrayList();
            if (!this.signature.getIsGenericParameter().booleanValue()) {
                LOG.debug("Collection is of Non generic type.Setting the same values as fetched from the test file.");
                for (Map<String, Object> object : convertFrom) {
                    String[] strValues = ((String)object.get(this.paramName)).split(":");
                    for (int i = 0; i < strValues.length; ++i) {
                        this.collection.add(strValues[i]);
                    }
                    potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)this.collection));
                }
            } else {
                String key;
                Iterator<String> i$ = this.converters.keySet().iterator();
                while (i$.hasNext() && (potentialAssignments = this.converters.get(key = i$.next()).convert(convertFrom)) == null) {
                }
            }
        }
        return potentialAssignments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection getCollectionInstance(Class parameterType, Class genericType) {
        try {
            if (Set.class.isAssignableFrom(parameterType)) {
                if (!EnumSet.class.isAssignableFrom(parameterType)) return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new TreeSet() : parameterType.newInstance();
                LOG.debug("Returning an instance of {}  for the input parameter of Type :{}", (Object)EnumSet.class.getSimpleName(), (Object)parameterType);
                return EnumSet.noneOf(genericType == null ? Object.class : genericType);
            }
            if (List.class.isAssignableFrom(parameterType)) {
                return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new LinkedList() : parameterType.newInstance();
            }
            if ("Deque".equals(parameterType.getSimpleName()) || "LinkedBlockingDeque".equals(parameterType.getSimpleName()) || "BlockingDeque".equals(parameterType.getSimpleName())) {
                Converter<?> converter = ConverterManager.findConverter(parameterType);
                if (converter != null) return (Collection)converter.instanceOfType();
                Assert.fail((String)("EasyTest does not natively support the Collection of type " + parameterType + " . In order to use this Collection type as parameter, provide an empty implementation of AbstractConveter " + "class with the generic type as " + parameterType + "or provide an implementation of instance() method of the Converter interface "));
                return null;
            } else {
                if (Queue.class.isAssignableFrom(parameterType)) {
                    if (!ArrayBlockingQueue.class.isAssignableFrom(parameterType)) return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new LinkedBlockingQueue() : parameterType.newInstance();
                    return new ArrayBlockingQueue(100);
                }
                if (!Collection.class.isAssignableFrom(parameterType)) return null;
                return new ArrayList();
            }
        }
        catch (Exception e) {
            LOG.error("Exception occured while trying to instantiate a Collection of Type : {} . Error is {}", (Object)parameterType, (Object)e);
            Assert.fail((String)("Exception occured while trying to instantiate a Collection of Type : " + parameterType + " . The exception is :" + e.toString()));
        }
        return null;
    }
}

