/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo;

import android.app.Activity;
import android.content.Context;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.EventLogger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tv.danmaku.ijk.media.exo.ExoSourceManager;
import tv.danmaku.ijk.media.player.AbstractMediaPlayer;
import tv.danmaku.ijk.media.player.MediaInfo;
import tv.danmaku.ijk.media.player.misc.IjkTrackInfo;

public class IjkExoMediaPlayer
extends AbstractMediaPlayer
implements Player.EventListener,
AnalyticsListener {
    private static final String TAG = "IjkExoMediaPlayer";
    private Context mAppContext;
    private SimpleExoPlayer mInternalPlayer;
    private EventLogger mEventLogger;
    private DefaultRenderersFactory renderersFactory;
    private MediaSource mMediaSource;
    private DefaultTrackSelector mTrackSelector;
    private String mDataSource;
    private int mVideoWidth;
    private int mVideoHeight;
    private Surface mSurface;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private int lastReportedPlaybackState;
    private boolean lastReportedPlayWhenReady;
    private boolean isPrepareing = true;
    private boolean isBuffering = false;
    private boolean isLooping = false;
    private boolean isPreview = false;
    private boolean isCache = false;
    private ExoSourceManager mExoSourceManager;
    private File mCacheDir;
    private int audioSessionId = 0;

    public IjkExoMediaPlayer(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.lastReportedPlaybackState = 1;
        this.mExoSourceManager = ExoSourceManager.newInstance(context, this.mHeaders);
    }

    public void setDisplay(SurfaceHolder sh) {
        if (sh == null) {
            this.setSurface(null);
        } else {
            this.setSurface(sh.getSurface());
        }
    }

    public void setSurface(Surface surface) {
        this.mSurface = surface;
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setVideoSurface(surface);
        }
    }

    public void setDataSource(Context context, Uri uri) {
        this.mDataSource = uri.toString();
        this.mMediaSource = this.mExoSourceManager.getMediaSource(this.mDataSource, this.isPreview, this.isCache, this.isLooping, this.mCacheDir);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) {
        this.setDataSource(context, uri);
    }

    public void setDataSource(String path) {
        this.setDataSource(this.mAppContext, Uri.parse((String)path));
    }

    public void setDataSource(FileDescriptor fd) {
        throw new UnsupportedOperationException("no support");
    }

    public String getDataSource() {
        return this.mDataSource;
    }

    public void prepareAsync() throws IllegalStateException {
        if (this.mInternalPlayer != null) {
            throw new IllegalStateException("can't prepare a prepared player");
        }
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)new DefaultBandwidthMeter());
        this.mTrackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.mTrackSelector.setParameters(new DefaultTrackSelector.ParametersBuilder().build());
        this.mEventLogger = new EventLogger((MappingTrackSelector)this.mTrackSelector);
        boolean preferExtensionDecoders = true;
        boolean useExtensionRenderers = true;
        int extensionRendererMode = useExtensionRenderers ? (preferExtensionDecoders ? 2 : 1) : 0;
        this.renderersFactory = new DefaultRenderersFactory(this.mAppContext, extensionRendererMode);
        DefaultLoadControl loadControl = new DefaultLoadControl();
        this.mInternalPlayer = ExoPlayerFactory.newSimpleInstance((RenderersFactory)this.renderersFactory, (TrackSelector)this.mTrackSelector, (LoadControl)loadControl, null);
        this.mInternalPlayer.addListener((Player.EventListener)this);
        this.mInternalPlayer.addAnalyticsListener((AnalyticsListener)this);
        this.mInternalPlayer.addAnalyticsListener((AnalyticsListener)this.mEventLogger);
        if (this.mSurface != null) {
            this.mInternalPlayer.setVideoSurface(this.mSurface);
        }
        this.mInternalPlayer.prepare(this.mMediaSource);
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    public void start() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    public void stop() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.release();
    }

    public void pause() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    public void setWakeMode(Context context, int mode) {
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
    }

    public IjkTrackInfo[] getTrackInfo() {
        return null;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public boolean isPlaying() {
        if (this.mInternalPlayer == null) {
            return false;
        }
        int state = this.mInternalPlayer.getPlaybackState();
        switch (state) {
            case 2: 
            case 3: {
                return this.mInternalPlayer.getPlayWhenReady();
            }
        }
        return false;
    }

    public void seekTo(long msec) throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.seekTo(msec);
    }

    public long getCurrentPosition() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getCurrentPosition();
    }

    public long getDuration() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getDuration();
    }

    public int getVideoSarNum() {
        return 1;
    }

    public int getVideoSarDen() {
        return 1;
    }

    public void reset() {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.release();
            this.mInternalPlayer.removeListener((Player.EventListener)this);
            this.mInternalPlayer.removeAnalyticsListener((AnalyticsListener)this);
            this.mInternalPlayer.removeAnalyticsListener((AnalyticsListener)this.mEventLogger);
            this.mInternalPlayer = null;
        }
        this.mSurface = null;
        this.mDataSource = null;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    public void setLooping(boolean looping) {
        this.isLooping = looping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        this.mInternalPlayer.setVolume((leftVolume + rightVolume) / 2.0f);
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public MediaInfo getMediaInfo() {
        return null;
    }

    public void setLogEnabled(boolean enable) {
    }

    public boolean isPlayable() {
        return true;
    }

    public void setAudioStreamType(int streamtype) {
    }

    public void setKeepInBackground(boolean keepInBackground) {
    }

    public void release() {
        if (this.mInternalPlayer != null) {
            this.reset();
            this.mEventLogger = null;
        }
    }

    public void stopPlayback() {
        this.mInternalPlayer.stop();
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setCache(boolean cache) {
        this.isCache = cache;
    }

    public File getCacheDir() {
        return this.mCacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.mCacheDir = cacheDir;
    }

    public MediaSource getMediaSource() {
        return this.mMediaSource;
    }

    public void setMediaSource(MediaSource mediaSource) {
        this.mMediaSource = mediaSource;
    }

    public ExoSourceManager getExoSourceManager() {
        return this.mExoSourceManager;
    }

    public void setSpeed(@Size(min=0L) float speed, @Size(min=0L) float pitch) {
        PlaybackParameters playbackParameters = new PlaybackParameters(speed, pitch);
        this.mInternalPlayer.setPlaybackParameters(playbackParameters);
    }

    public float getSpeed() {
        return this.mInternalPlayer.getPlaybackParameters().speed;
    }

    public int getBufferedPercentage() {
        if (this.mInternalPlayer == null) {
            return 0;
        }
        return this.mInternalPlayer.getBufferedPercentage();
    }

    public ArrayList<Integer> getTrackGroup() {
        ArrayList<Integer> trackInfos = new ArrayList<Integer>();
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.mTrackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return trackInfos;
        }
        block5: for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            int trackType;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(i);
            if (trackGroups.length == 0) continue;
            switch (this.mInternalPlayer.getRendererType(i)) {
                case 1: {
                    trackType = 1;
                    break;
                }
                case 2: {
                    trackType = 2;
                    break;
                }
                case 3: {
                    trackType = 3;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            trackInfos.add(trackType);
        }
        return trackInfos;
    }

    public long getTotalRxBytes(@NonNull Activity activity) {
        return TrafficStats.getUidRxBytes((int)activity.getApplicationInfo().uid) == -1L ? 0L : TrafficStats.getTotalRxBytes() / 1024L;
    }

    public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.e((String)TAG, (String)("onPlayerStateChanged: playWhenReady = " + playWhenReady + ", playbackState = " + playbackState));
        if (this.lastReportedPlayWhenReady != playWhenReady || this.lastReportedPlaybackState != playbackState) {
            if (this.isBuffering) {
                switch (playbackState) {
                    case 3: 
                    case 4: {
                        this.notifyOnInfo(702, this.mInternalPlayer.getBufferedPercentage());
                        this.isBuffering = false;
                    }
                }
            }
            if (this.isPrepareing) {
                switch (playbackState) {
                    case 3: {
                        this.notifyOnPrepared();
                        this.isPrepareing = false;
                    }
                }
            }
            switch (playbackState) {
                case 1: {
                    this.notifyOnCompletion();
                    break;
                }
                case 2: {
                    this.notifyOnInfo(701, this.mInternalPlayer.getBufferedPercentage());
                    this.isBuffering = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.notifyOnCompletion();
                    break;
                }
            }
        }
        this.lastReportedPlayWhenReady = playWhenReady;
        this.lastReportedPlaybackState = playbackState;
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
    }

    public void onPlayerError(ExoPlaybackException error) {
        this.notifyOnError(1, 1);
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void onSeekProcessed() {
    }

    public void onPlayerStateChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
    }

    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
    }

    public void onSeekStarted(AnalyticsListener.EventTime eventTime) {
    }

    public void onSeekProcessed(AnalyticsListener.EventTime eventTime) {
    }

    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
    }

    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
    }

    public void onLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
    }

    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
    }

    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadStarted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadError(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onMediaPeriodCreated(AnalyticsListener.EventTime eventTime) {
    }

    public void onMediaPeriodReleased(AnalyticsListener.EventTime eventTime) {
    }

    public void onReadingStarted(AnalyticsListener.EventTime eventTime) {
    }

    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    public void onViewportSizeChange(AnalyticsListener.EventTime eventTime, int width, int height) {
    }

    public void onNetworkTypeChanged(AnalyticsListener.EventTime eventTime, @Nullable NetworkInfo networkInfo) {
    }

    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
    }

    public void onDecoderEnabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    public void onDecoderInitialized(AnalyticsListener.EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
    }

    public void onDecoderInputFormatChanged(AnalyticsListener.EventTime eventTime, int trackType, Format format) {
    }

    public void onDecoderDisabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    public void onAudioSessionId(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        this.audioSessionId = audioSessionId;
    }

    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.notifyOnVideoSizeChanged(width, height, 1, 1);
        if (unappliedRotationDegrees > 0) {
            this.notifyOnInfo(10001, unappliedRotationDegrees);
        }
    }

    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Surface surface) {
    }

    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
    }

    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
    }

    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
    }

    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
    }
}

