/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo.demo;

import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.GeobFrame;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.metadata.id3.UrlLinkFrame;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

public final class EventLogger
implements Player.EventListener,
AudioRendererEventListener,
VideoRendererEventListener,
AdaptiveMediaSourceEventListener,
ExtractorMediaSource.EventListener,
DefaultDrmSessionManager.EventListener,
MetadataRenderer.Output {
    private static final String TAG = "EventLogger";
    private static final int MAX_TIMELINE_ITEM_LINES = 3;
    private static final NumberFormat TIME_FORMAT = NumberFormat.getInstance(Locale.US);
    private final MappingTrackSelector trackSelector;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long startTimeMs;

    public EventLogger(MappingTrackSelector trackSelector) {
        this.trackSelector = trackSelector;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.startTimeMs = SystemClock.elapsedRealtime();
    }

    public void onLoadingChanged(boolean isLoading) {
        Log.d((String)TAG, (String)("loading [" + isLoading + "]"));
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        Log.d((String)TAG, (String)("state [" + this.getSessionTimeString() + ", " + playWhenReady + ", " + EventLogger.getStateString(state) + "]"));
    }

    public void onRepeatModeChanged(int repeatMode) {
        Log.d((String)TAG, (String)("repeatMode [" + EventLogger.getRepeatModeString(repeatMode) + "]"));
    }

    public void onPositionDiscontinuity() {
        Log.d((String)TAG, (String)"positionDiscontinuity");
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        Log.d((String)TAG, (String)("playbackParameters " + String.format("[speed=%.2f, pitch=%.2f]", Float.valueOf(playbackParameters.speed), Float.valueOf(playbackParameters.pitch))));
    }

    public void onTimelineChanged(Timeline timeline, Object manifest) {
        int i;
        int periodCount = timeline.getPeriodCount();
        int windowCount = timeline.getWindowCount();
        Log.d((String)TAG, (String)("sourceInfo [periodCount=" + periodCount + ", windowCount=" + windowCount));
        for (i = 0; i < Math.min(periodCount, 3); ++i) {
            timeline.getPeriod(i, this.period);
            Log.d((String)TAG, (String)("  period [" + EventLogger.getTimeString(this.period.getDurationMs()) + "]"));
        }
        if (periodCount > 3) {
            Log.d((String)TAG, (String)"  ...");
        }
        for (i = 0; i < Math.min(windowCount, 3); ++i) {
            timeline.getWindow(i, this.window);
            Log.d((String)TAG, (String)("  window [" + EventLogger.getTimeString(this.window.getDurationMs()) + ", " + this.window.isSeekable + ", " + this.window.isDynamic + "]"));
        }
        if (windowCount > 3) {
            Log.d((String)TAG, (String)"  ...");
        }
        Log.d((String)TAG, (String)"]");
    }

    public void onPlayerError(ExoPlaybackException e) {
        Log.e((String)TAG, (String)("playerFailed [" + this.getSessionTimeString() + "]"), (Throwable)e);
    }

    public void onTracksChanged(TrackGroupArray ignored, TrackSelectionArray trackSelections) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            Log.d((String)TAG, (String)"Tracks []");
            return;
        }
        Log.d((String)TAG, (String)"Tracks [");
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.length; ++rendererIndex) {
            TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            TrackSelection trackSelection = trackSelections.get(rendererIndex);
            if (rendererTrackGroups.length <= 0) continue;
            Log.d((String)TAG, (String)("  Renderer:" + rendererIndex + " ["));
            for (int groupIndex = 0; groupIndex < rendererTrackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = rendererTrackGroups.get(groupIndex);
                String adaptiveSupport = EventLogger.getAdaptiveSupportString(trackGroup.length, mappedTrackInfo.getAdaptiveSupport(rendererIndex, groupIndex, false));
                Log.d((String)TAG, (String)("    Group:" + groupIndex + ", adaptive_supported=" + adaptiveSupport + " ["));
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(trackSelection, trackGroup, trackIndex);
                    String formatSupport = EventLogger.getFormatSupportString(mappedTrackInfo.getTrackFormatSupport(rendererIndex, groupIndex, trackIndex));
                    Log.d((String)TAG, (String)("      " + status + " Track:" + trackIndex + ", " + Format.toLogString((Format)trackGroup.getFormat(trackIndex)) + ", supported=" + formatSupport));
                }
                Log.d((String)TAG, (String)"    ]");
            }
            if (trackSelection != null) {
                for (int selectionIndex = 0; selectionIndex < trackSelection.length(); ++selectionIndex) {
                    Metadata metadata = trackSelection.getFormat((int)selectionIndex).metadata;
                    if (metadata == null) continue;
                    Log.d((String)TAG, (String)"    Metadata [");
                    this.printMetadata(metadata, "      ");
                    Log.d((String)TAG, (String)"    ]");
                    break;
                }
            }
            Log.d((String)TAG, (String)"  ]");
        }
        TrackGroupArray unassociatedTrackGroups = mappedTrackInfo.getUnassociatedTrackGroups();
        if (unassociatedTrackGroups.length > 0) {
            Log.d((String)TAG, (String)"  Renderer:None [");
            for (int groupIndex = 0; groupIndex < unassociatedTrackGroups.length; ++groupIndex) {
                Log.d((String)TAG, (String)("    Group:" + groupIndex + " ["));
                TrackGroup trackGroup = unassociatedTrackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(false);
                    String formatSupport = EventLogger.getFormatSupportString(0);
                    Log.d((String)TAG, (String)("      " + status + " Track:" + trackIndex + ", " + Format.toLogString((Format)trackGroup.getFormat(trackIndex)) + ", supported=" + formatSupport));
                }
                Log.d((String)TAG, (String)"    ]");
            }
            Log.d((String)TAG, (String)"  ]");
        }
        Log.d((String)TAG, (String)"]");
    }

    public void onMetadata(Metadata metadata) {
        Log.d((String)TAG, (String)"onMetadata [");
        this.printMetadata(metadata, "  ");
        Log.d((String)TAG, (String)"]");
    }

    public void onAudioEnabled(DecoderCounters counters) {
        Log.d((String)TAG, (String)("audioEnabled [" + this.getSessionTimeString() + "]"));
    }

    public void onAudioSessionId(int audioSessionId) {
        Log.d((String)TAG, (String)("audioSessionId [" + audioSessionId + "]"));
    }

    public void onAudioDecoderInitialized(String decoderName, long elapsedRealtimeMs, long initializationDurationMs) {
        Log.d((String)TAG, (String)("audioDecoderInitialized [" + this.getSessionTimeString() + ", " + decoderName + "]"));
    }

    public void onAudioInputFormatChanged(Format format) {
        Log.d((String)TAG, (String)("audioFormatChanged [" + this.getSessionTimeString() + ", " + Format.toLogString((Format)format) + "]"));
    }

    public void onAudioDisabled(DecoderCounters counters) {
        Log.d((String)TAG, (String)("audioDisabled [" + this.getSessionTimeString() + "]"));
    }

    public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        this.printInternalError("audioTrackUnderrun [" + bufferSize + ", " + bufferSizeMs + ", " + elapsedSinceLastFeedMs + "]", null);
    }

    public void onVideoEnabled(DecoderCounters counters) {
        Log.d((String)TAG, (String)("videoEnabled [" + this.getSessionTimeString() + "]"));
    }

    public void onVideoDecoderInitialized(String decoderName, long elapsedRealtimeMs, long initializationDurationMs) {
        Log.d((String)TAG, (String)("videoDecoderInitialized [" + this.getSessionTimeString() + ", " + decoderName + "]"));
    }

    public void onVideoInputFormatChanged(Format format) {
        Log.d((String)TAG, (String)("videoFormatChanged [" + this.getSessionTimeString() + ", " + Format.toLogString((Format)format) + "]"));
    }

    public void onVideoDisabled(DecoderCounters counters) {
        Log.d((String)TAG, (String)("videoDisabled [" + this.getSessionTimeString() + "]"));
    }

    public void onDroppedFrames(int count, long elapsed) {
        Log.d((String)TAG, (String)("droppedFrames [" + this.getSessionTimeString() + ", " + count + "]"));
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        Log.d((String)TAG, (String)("videoSizeChanged [" + width + ", " + height + "]"));
    }

    public void onRenderedFirstFrame(Surface surface) {
        Log.d((String)TAG, (String)("renderedFirstFrame [" + surface + "]"));
    }

    public void onDrmSessionManagerError(Exception e) {
        this.printInternalError("drmSessionManagerError", e);
    }

    public void onDrmKeysRestored() {
        Log.d((String)TAG, (String)("drmKeysRestored [" + this.getSessionTimeString() + "]"));
    }

    public void onDrmKeysRemoved() {
        Log.d((String)TAG, (String)("drmKeysRemoved [" + this.getSessionTimeString() + "]"));
    }

    public void onDrmKeysLoaded() {
        Log.d((String)TAG, (String)("drmKeysLoaded [" + this.getSessionTimeString() + "]"));
    }

    public void onLoadError(IOException error) {
        this.printInternalError("loadError", error);
    }

    public void onLoadStarted(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs) {
    }

    public void onLoadError(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded, IOException error, boolean wasCanceled) {
        this.printInternalError("loadError", error);
    }

    public void onLoadCanceled(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
    }

    public void onLoadCompleted(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
    }

    public void onUpstreamDiscarded(int trackType, long mediaStartTimeMs, long mediaEndTimeMs) {
    }

    public void onDownstreamFormatChanged(int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaTimeMs) {
    }

    private void printInternalError(String type, Exception e) {
        Log.e((String)TAG, (String)("internalError [" + this.getSessionTimeString() + ", " + type + "]"), (Throwable)e);
    }

    private void printMetadata(Metadata metadata, String prefix) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (entry instanceof TextInformationFrame) {
                TextInformationFrame textInformationFrame = (TextInformationFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: value=%s", textInformationFrame.id, textInformationFrame.value)));
                continue;
            }
            if (entry instanceof UrlLinkFrame) {
                UrlLinkFrame urlLinkFrame = (UrlLinkFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: url=%s", urlLinkFrame.id, urlLinkFrame.url)));
                continue;
            }
            if (entry instanceof PrivFrame) {
                PrivFrame privFrame = (PrivFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: owner=%s", privFrame.id, privFrame.owner)));
                continue;
            }
            if (entry instanceof GeobFrame) {
                GeobFrame geobFrame = (GeobFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: mimeType=%s, filename=%s, description=%s", geobFrame.id, geobFrame.mimeType, geobFrame.filename, geobFrame.description)));
                continue;
            }
            if (entry instanceof ApicFrame) {
                ApicFrame apicFrame = (ApicFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: mimeType=%s, description=%s", apicFrame.id, apicFrame.mimeType, apicFrame.description)));
                continue;
            }
            if (entry instanceof CommentFrame) {
                CommentFrame commentFrame = (CommentFrame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s: language=%s, description=%s", commentFrame.id, commentFrame.language, commentFrame.description)));
                continue;
            }
            if (entry instanceof Id3Frame) {
                Id3Frame id3Frame = (Id3Frame)entry;
                Log.d((String)TAG, (String)(prefix + String.format("%s", id3Frame.id)));
                continue;
            }
            if (!(entry instanceof EventMessage)) continue;
            EventMessage eventMessage = (EventMessage)entry;
            Log.d((String)TAG, (String)(prefix + String.format("EMSG: scheme=%s, id=%d, value=%s", eventMessage.schemeIdUri, eventMessage.id, eventMessage.value)));
        }
    }

    private String getSessionTimeString() {
        return EventLogger.getTimeString(SystemClock.elapsedRealtime() - this.startTimeMs);
    }

    private static String getTimeString(long timeMs) {
        return timeMs == -9223372036854775807L ? "?" : TIME_FORMAT.format((float)timeMs / 1000.0f);
    }

    private static String getStateString(int state) {
        switch (state) {
            case 2: {
                return "B";
            }
            case 4: {
                return "E";
            }
            case 1: {
                return "I";
            }
            case 3: {
                return "R";
            }
        }
        return "?";
    }

    private static String getFormatSupportString(int formatSupport) {
        switch (formatSupport) {
            case 4: {
                return "YES";
            }
            case 3: {
                return "NO_EXCEEDS_CAPABILITIES";
            }
            case 2: {
                return "NO_UNSUPPORTED_DRM";
            }
            case 1: {
                return "NO_UNSUPPORTED_TYPE";
            }
            case 0: {
                return "NO";
            }
        }
        return "?";
    }

    private static String getAdaptiveSupportString(int trackCount, int adaptiveSupport) {
        if (trackCount < 2) {
            return "N/A";
        }
        switch (adaptiveSupport) {
            case 16: {
                return "YES";
            }
            case 8: {
                return "YES_NOT_SEAMLESS";
            }
            case 0: {
                return "NO";
            }
        }
        return "?";
    }

    private static String getTrackStatusString(TrackSelection selection, TrackGroup group, int trackIndex) {
        return EventLogger.getTrackStatusString(selection != null && selection.getTrackGroup() == group && selection.indexOf(trackIndex) != -1);
    }

    private static String getTrackStatusString(boolean enabled) {
        return enabled ? "[X]" : "[ ]";
    }

    private static String getRepeatModeString(int repeatMode) {
        switch (repeatMode) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "ONE";
            }
            case 2: {
                return "ALL";
            }
        }
        return "?";
    }

    static {
        TIME_FORMAT.setMinimumFractionDigits(2);
        TIME_FORMAT.setMaximumFractionDigits(2);
        TIME_FORMAT.setGroupingUsed(false);
    }
}

