/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Size;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.ext.rtmp.RtmpDataSourceFactory;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.io.FileDescriptor;
import java.util.Map;
import tv.danmaku.ijk.media.exo.demo.EventLogger;
import tv.danmaku.ijk.media.exo.demo.player.SimpleExoPlayer2;
import tv.danmaku.ijk.media.player.AbstractMediaPlayer;
import tv.danmaku.ijk.media.player.MediaInfo;
import tv.danmaku.ijk.media.player.misc.IjkTrackInfo;

public class IjkExoMediaPlayer
extends AbstractMediaPlayer
implements Player.EventListener,
VideoRendererEventListener,
AudioRendererEventListener {
    private static final String TAG = "IjkExoMediaPlayer";
    private Context mAppContext;
    private SimpleExoPlayer2 mInternalPlayer;
    private EventLogger mEventLogger;
    private DefaultRenderersFactory renderersFactory;
    private MediaSource mMediaSource;
    private DefaultTrackSelector mTrackSelector;
    private String mDataSource;
    private int mVideoWidth;
    private int mVideoHeight;
    private Surface mSurface;
    private Handler mainHandler;
    private int lastReportedPlaybackState;
    private boolean lastReportedPlayWhenReady;
    private boolean mIsPrepareing = true;
    private boolean mIsBuffering = false;
    private int audioSessionId = 0;
    public static final int TYPE_RTMP = 4;

    public IjkExoMediaPlayer(Context context) {
        this.mAppContext = context.getApplicationContext();
        Looper eventLooper = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
        this.mainHandler = new Handler(eventLooper);
        this.lastReportedPlaybackState = 1;
    }

    public void setDisplay(SurfaceHolder sh) {
        if (sh == null) {
            this.setSurface(null);
        } else {
            this.setSurface(sh.getSurface());
        }
    }

    public void setSurface(Surface surface) {
        this.mSurface = surface;
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setVideoSurface(surface);
        }
    }

    public void setDataSource(Context context, Uri uri) {
        this.mDataSource = uri.toString();
        this.mMediaSource = this.getMediaSource(false);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) {
        this.setDataSource(context, uri);
    }

    public void setDataSource(String path) {
        this.setDataSource(this.mAppContext, Uri.parse((String)path));
    }

    public void setDataSource(FileDescriptor fd) {
        throw new UnsupportedOperationException("no support");
    }

    public String getDataSource() {
        return this.mDataSource;
    }

    public void prepareAsync() throws IllegalStateException {
        if (this.mInternalPlayer != null) {
            throw new IllegalStateException("can't prepare a prepared player");
        }
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)new DefaultBandwidthMeter());
        this.mTrackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.mEventLogger = new EventLogger((MappingTrackSelector)this.mTrackSelector);
        boolean preferExtensionDecoders = true;
        boolean useExtensionRenderers = true;
        int extensionRendererMode = useExtensionRenderers ? (preferExtensionDecoders ? 2 : 1) : 0;
        this.renderersFactory = new DefaultRenderersFactory(this.mAppContext, null, extensionRendererMode);
        DefaultLoadControl loadControl = new DefaultLoadControl();
        this.mInternalPlayer = new SimpleExoPlayer2((RenderersFactory)this.renderersFactory, (TrackSelector)this.mTrackSelector, (LoadControl)loadControl);
        this.mInternalPlayer.addListener(this);
        this.mInternalPlayer.setVideoDebugListener(this);
        this.mInternalPlayer.setAudioDebugListener(this);
        this.mInternalPlayer.addListener(this.mEventLogger);
        if (this.mSurface != null) {
            this.mInternalPlayer.setVideoSurface(this.mSurface);
        }
        this.mInternalPlayer.prepare(this.mMediaSource);
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    public void start() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    public void stop() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.release();
    }

    public void pause() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    public void setWakeMode(Context context, int mode) {
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
    }

    public IjkTrackInfo[] getTrackInfo() {
        return null;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public boolean isPlaying() {
        if (this.mInternalPlayer == null) {
            return false;
        }
        int state = this.mInternalPlayer.getPlaybackState();
        switch (state) {
            case 2: 
            case 3: {
                return this.mInternalPlayer.getPlayWhenReady();
            }
        }
        return false;
    }

    public void seekTo(long msec) throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.seekTo(msec);
    }

    public long getCurrentPosition() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getCurrentPosition();
    }

    public long getDuration() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getDuration();
    }

    public int getVideoSarNum() {
        return 1;
    }

    public int getVideoSarDen() {
        return 1;
    }

    public void reset() {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.release();
            this.mInternalPlayer = null;
        }
        this.mSurface = null;
        this.mDataSource = null;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    public void setLooping(boolean looping) {
        throw new UnsupportedOperationException("no support");
    }

    public boolean isLooping() {
        return false;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        this.mInternalPlayer.setVolume((leftVolume + rightVolume) / 2.0f);
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public MediaInfo getMediaInfo() {
        return null;
    }

    public void setLogEnabled(boolean enable) {
    }

    public boolean isPlayable() {
        return true;
    }

    public void setAudioStreamType(int streamtype) {
    }

    public void setKeepInBackground(boolean keepInBackground) {
    }

    public void release() {
        if (this.mInternalPlayer != null) {
            this.reset();
            this.mEventLogger = null;
        }
    }

    public void stopPlayback() {
        this.mInternalPlayer.stop();
    }

    public void setSpeed(@Size(min=0L) float speed, @Size(min=0L) float pitch) {
        PlaybackParameters playbackParameters = new PlaybackParameters(speed, pitch);
        this.mInternalPlayer.setPlaybackParameters(playbackParameters);
    }

    public float getSpeed() {
        return this.mInternalPlayer.getPlaybackParameters().speed;
    }

    public int getBufferedPercentage() {
        if (this.mInternalPlayer == null) {
            return 0;
        }
        return this.mInternalPlayer.getBufferedPercentage();
    }

    private int inferContentType(String fileName) {
        if ((fileName = Util.toLowerInvariant((String)fileName)).endsWith(".mpd")) {
            return 0;
        }
        if (fileName.endsWith(".m3u8")) {
            return 2;
        }
        if (fileName.endsWith(".ism") || fileName.endsWith(".isml") || fileName.endsWith(".ism/manifest") || fileName.endsWith(".isml/manifest")) {
            return 1;
        }
        if (fileName.startsWith("rtmp:")) {
            return 4;
        }
        return 3;
    }

    private MediaSource getMediaSource(boolean preview) {
        Uri contentUri = Uri.parse((String)this.mDataSource);
        int contentType = this.inferContentType(this.mDataSource);
        switch (contentType) {
            case 1: {
                return new SsMediaSource(contentUri, (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(preview)), (SsChunkSource.Factory)new DefaultSsChunkSource.Factory(this.getDataSourceFactory(preview)), this.mainHandler, null);
            }
            case 0: {
                return new DashMediaSource(contentUri, (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(preview)), (DashChunkSource.Factory)new DefaultDashChunkSource.Factory(this.getDataSourceFactory(preview)), this.mainHandler, null);
            }
            case 2: {
                return new HlsMediaSource(contentUri, this.getDataSourceFactory(preview), this.mainHandler, null);
            }
            case 4: {
                RtmpDataSourceFactory rtmpDataSourceFactory = new RtmpDataSourceFactory(null);
                return new ExtractorMediaSource(contentUri, (DataSource.Factory)rtmpDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), this.mainHandler, null);
            }
        }
        return new ExtractorMediaSource(contentUri, this.getDataSourceFactory(preview), (ExtractorsFactory)new DefaultExtractorsFactory(), this.mainHandler, null);
    }

    private DataSource.Factory getDataSourceFactory(boolean preview) {
        return new DefaultDataSourceFactory(this.mAppContext, (TransferListener)(preview ? null : new DefaultBandwidthMeter()), this.getHttpDataSourceFactory(preview));
    }

    private DataSource.Factory getHttpDataSourceFactory(boolean preview) {
        return new DefaultHttpDataSourceFactory(Util.getUserAgent((Context)this.mAppContext, (String)TAG), (TransferListener)(preview ? null : new DefaultBandwidthMeter()));
    }

    public void onTimelineChanged(Timeline timeline, Object manifest) {
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.e((String)TAG, (String)("onPlayerStateChanged: playWhenReady = " + playWhenReady + ", playbackState = " + playbackState));
        if (this.lastReportedPlayWhenReady != playWhenReady || this.lastReportedPlaybackState != playbackState) {
            if (this.mIsBuffering) {
                switch (playbackState) {
                    case 3: 
                    case 4: {
                        this.notifyOnInfo(702, this.mInternalPlayer.getBufferedPercentage());
                        this.mIsBuffering = false;
                    }
                }
            }
            if (this.mIsPrepareing) {
                switch (playbackState) {
                    case 3: {
                        this.notifyOnPrepared();
                        this.mIsPrepareing = false;
                    }
                }
            }
            switch (playbackState) {
                case 2: {
                    this.notifyOnInfo(701, this.mInternalPlayer.getBufferedPercentage());
                    this.mIsBuffering = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.notifyOnCompletion();
                    break;
                }
            }
        }
        this.lastReportedPlayWhenReady = playWhenReady;
        this.lastReportedPlaybackState = playbackState;
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onPlayerError(ExoPlaybackException error) {
        this.notifyOnError(1, 1);
    }

    public void onPositionDiscontinuity() {
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void onAudioEnabled(DecoderCounters counters) {
    }

    public void onAudioSessionId(int audioSessionId) {
        this.audioSessionId = audioSessionId;
    }

    public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    public void onAudioInputFormatChanged(Format format) {
    }

    public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    public void onAudioDisabled(DecoderCounters counters) {
        this.audioSessionId = 0;
    }

    public void onVideoEnabled(DecoderCounters counters) {
    }

    public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    public void onVideoInputFormatChanged(Format format) {
    }

    public void onDroppedFrames(int count, long elapsedMs) {
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.notifyOnVideoSizeChanged(width, height, 1, 1);
        if (unappliedRotationDegrees > 0) {
            this.notifyOnInfo(10001, unappliedRotationDegrees);
        }
    }

    public void onRenderedFirstFrame(Surface surface) {
    }

    public void onVideoDisabled(DecoderCounters counters) {
    }
}

