/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo.demo.player;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

@TargetApi(value=16)
public class SimpleExoPlayer2
implements ExoPlayer {
    private static final String TAG = "SimpleExoPlayer2";
    protected final Renderer[] renderers;
    private final ExoPlayer player;
    private final ComponentListener componentListener = new ComponentListener();
    private final CopyOnWriteArraySet<VideoListener> videoListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<TextRenderer.Output> textOutputs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<MetadataRenderer.Output> metadataOutputs = new CopyOnWriteArraySet();
    private final int videoRendererCount;
    private final int audioRendererCount;
    private Format videoFormat;
    private Format audioFormat;
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    private SurfaceHolder surfaceHolder;
    private TextureView textureView;
    private AudioRendererEventListener audioDebugListener;
    private VideoRendererEventListener videoDebugListener;
    private DecoderCounters videoDecoderCounters;
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private AudioAttributes audioAttributes;
    private float audioVolume;

    public SimpleExoPlayer2(RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl) {
        Looper eventLooper = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
        Handler eventHandler = new Handler(eventLooper);
        this.renderers = renderersFactory.createRenderers(eventHandler, (VideoRendererEventListener)this.componentListener, (AudioRendererEventListener)this.componentListener, (TextRenderer.Output)this.componentListener, (MetadataRenderer.Output)this.componentListener);
        int videoRendererCount = 0;
        int audioRendererCount = 0;
        block4: for (Renderer renderer : this.renderers) {
            switch (renderer.getTrackType()) {
                case 2: {
                    ++videoRendererCount;
                    continue block4;
                }
                case 1: {
                    ++audioRendererCount;
                }
            }
        }
        this.videoRendererCount = videoRendererCount;
        this.audioRendererCount = audioRendererCount;
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.videoScalingMode = 1;
        this.player = ExoPlayerFactory.newInstance((Renderer[])this.renderers, (TrackSelector)trackSelector, (LoadControl)loadControl);
    }

    public void setVideoScalingMode(int videoScalingMode) {
        this.videoScalingMode = videoScalingMode;
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.videoRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage((ExoPlayer.ExoPlayerComponent)renderer, 4, (Object)videoScalingMode);
        }
        this.player.sendMessages(messages);
    }

    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
    }

    public void clearVideoSurface(Surface surface) {
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            this.setVideoSurfaceInternal(surface != null && surface.isValid() ? surface : null, false);
        }
    }

    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void clearVideoSurfaceView(SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void setVideoTextureView(TextureView textureView) {
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
        } else {
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            this.setVideoSurfaceInternal(surfaceTexture == null ? null : new Surface(surfaceTexture), true);
        }
    }

    public void clearVideoTextureView(TextureView textureView) {
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    @Deprecated
    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType((int)streamType);
        int contentType = Util.getAudioContentTypeForStreamType((int)streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        this.setAudioAttributes(audioAttributes);
    }

    @Deprecated
    public int getAudioStreamType() {
        return Util.getStreamTypeForAudioUsage((int)this.audioAttributes.usage);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
        this.audioAttributes = audioAttributes;
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.audioRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage((ExoPlayer.ExoPlayerComponent)renderer, 3, (Object)audioAttributes);
        }
        this.player.sendMessages(messages);
    }

    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    public void setVolume(float audioVolume) {
        this.audioVolume = audioVolume;
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.audioRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage((ExoPlayer.ExoPlayerComponent)renderer, 2, (Object)Float.valueOf(audioVolume));
        }
        this.player.sendMessages(messages);
    }

    public float getVolume() {
        return this.audioVolume;
    }

    @Deprecated
    @TargetApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams params) {
        PlaybackParameters playbackParameters;
        if (params != null) {
            params.allowDefaults();
            playbackParameters = new PlaybackParameters(params.getSpeed(), params.getPitch());
        } else {
            playbackParameters = null;
        }
        this.setPlaybackParameters(playbackParameters);
    }

    public Format getVideoFormat() {
        return this.videoFormat;
    }

    public Format getAudioFormat() {
        return this.audioFormat;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public void addVideoListener(VideoListener listener) {
        this.videoListeners.add(listener);
    }

    public void removeVideoListener(VideoListener listener) {
        this.videoListeners.remove(listener);
    }

    @Deprecated
    public void setVideoListener(VideoListener listener) {
        this.videoListeners.clear();
        if (listener != null) {
            this.addVideoListener(listener);
        }
    }

    @Deprecated
    public void clearVideoListener(VideoListener listener) {
        this.removeVideoListener(listener);
    }

    public void addTextOutput(TextRenderer.Output listener) {
        this.textOutputs.add(listener);
    }

    public void removeTextOutput(TextRenderer.Output listener) {
        this.textOutputs.remove(listener);
    }

    @Deprecated
    public void setTextOutput(TextRenderer.Output output) {
        this.textOutputs.clear();
        if (output != null) {
            this.addTextOutput(output);
        }
    }

    @Deprecated
    public void clearTextOutput(TextRenderer.Output output) {
        this.removeTextOutput(output);
    }

    public void addMetadataOutput(MetadataRenderer.Output listener) {
        this.metadataOutputs.add(listener);
    }

    public void removeMetadataOutput(MetadataRenderer.Output listener) {
        this.metadataOutputs.remove(listener);
    }

    @Deprecated
    public void setMetadataOutput(MetadataRenderer.Output output) {
        this.metadataOutputs.clear();
        if (output != null) {
            this.addMetadataOutput(output);
        }
    }

    @Deprecated
    public void clearMetadataOutput(MetadataRenderer.Output output) {
        this.removeMetadataOutput(output);
    }

    public void setVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListener = listener;
    }

    public void setAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListener = listener;
    }

    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public void addListener(Player.EventListener listener) {
        this.player.addListener(listener);
    }

    public void removeListener(Player.EventListener listener) {
        this.player.removeListener(listener);
    }

    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    public void prepare(MediaSource mediaSource) {
        this.player.prepare(mediaSource);
    }

    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.player.prepare(mediaSource, resetPosition, resetState);
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    public int getRepeatMode() {
        return this.player.getRepeatMode();
    }

    public void setRepeatMode(int repeatMode) {
        this.player.setRepeatMode(repeatMode);
    }

    public boolean isLoading() {
        return this.player.isLoading();
    }

    public void seekToDefaultPosition() {
        this.player.seekToDefaultPosition();
    }

    public void seekToDefaultPosition(int windowIndex) {
        this.player.seekToDefaultPosition(windowIndex);
    }

    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
    }

    public void seekTo(int windowIndex, long positionMs) {
        this.player.seekTo(windowIndex, positionMs);
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.player.setPlaybackParameters(playbackParameters);
    }

    public PlaybackParameters getPlaybackParameters() {
        return this.player.getPlaybackParameters();
    }

    public void stop() {
        this.player.stop();
    }

    public void release() {
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
    }

    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.sendMessages(messages);
    }

    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.blockingSendMessages(messages);
    }

    public int getRendererCount() {
        return this.player.getRendererCount();
    }

    public int getRendererType(int index) {
        return this.player.getRendererType(index);
    }

    public TrackGroupArray getCurrentTrackGroups() {
        return this.player.getCurrentTrackGroups();
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        return this.player.getCurrentTrackSelections();
    }

    public Timeline getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    public boolean isCurrentWindowDynamic() {
        return this.player.isCurrentWindowDynamic();
    }

    public boolean isCurrentWindowSeekable() {
        return this.player.isCurrentWindowSeekable();
    }

    public boolean isPlayingAd() {
        return this.player.isPlayingAd();
    }

    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean ownsSurface) {
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.videoRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage((ExoPlayer.ExoPlayerComponent)renderer, 1, (Object)surface);
        }
        if (this.surface != null && this.surface != surface) {
            this.player.blockingSendMessages(messages);
            if (this.ownsSurface) {
                this.surface.release();
            }
        } else {
            this.player.sendMessages(messages);
        }
        this.surface = surface;
        this.ownsSurface = ownsSurface;
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextRenderer.Output,
    MetadataRenderer.Output,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener {
        private ComponentListener() {
        }

        public void onVideoEnabled(DecoderCounters counters) {
            SimpleExoPlayer2.this.videoDecoderCounters = counters;
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onVideoEnabled(counters);
            }
        }

        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        public void onVideoInputFormatChanged(Format format) {
            SimpleExoPlayer2.this.videoFormat = format;
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onVideoInputFormatChanged(format);
            }
        }

        public void onDroppedFrames(int count, long elapsed) {
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onDroppedFrames(count, elapsed);
            }
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            for (VideoListener videoListener : SimpleExoPlayer2.this.videoListeners) {
                videoListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
        }

        public void onRenderedFirstFrame(Surface surface) {
            if (SimpleExoPlayer2.this.surface == surface) {
                for (VideoListener videoListener : SimpleExoPlayer2.this.videoListeners) {
                    videoListener.onRenderedFirstFrame();
                }
            }
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onRenderedFirstFrame(surface);
            }
        }

        public void onVideoDisabled(DecoderCounters counters) {
            if (SimpleExoPlayer2.this.videoDebugListener != null) {
                SimpleExoPlayer2.this.videoDebugListener.onVideoDisabled(counters);
            }
            SimpleExoPlayer2.this.videoFormat = null;
            SimpleExoPlayer2.this.videoDecoderCounters = null;
        }

        public void onAudioEnabled(DecoderCounters counters) {
            SimpleExoPlayer2.this.audioDecoderCounters = counters;
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioEnabled(counters);
            }
        }

        public void onAudioSessionId(int sessionId) {
            SimpleExoPlayer2.this.audioSessionId = sessionId;
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioSessionId(sessionId);
            }
        }

        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        public void onAudioInputFormatChanged(Format format) {
            SimpleExoPlayer2.this.audioFormat = format;
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioInputFormatChanged(format);
            }
        }

        public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }

        public void onAudioDisabled(DecoderCounters counters) {
            if (SimpleExoPlayer2.this.audioDebugListener != null) {
                SimpleExoPlayer2.this.audioDebugListener.onAudioDisabled(counters);
            }
            SimpleExoPlayer2.this.audioFormat = null;
            SimpleExoPlayer2.this.audioDecoderCounters = null;
            SimpleExoPlayer2.this.audioSessionId = 0;
        }

        public void onCues(List<Cue> cues) {
            for (TextRenderer.Output textOutput : SimpleExoPlayer2.this.textOutputs) {
                textOutput.onCues(cues);
            }
        }

        public void onMetadata(Metadata metadata) {
            for (MetadataRenderer.Output metadataOutput : SimpleExoPlayer2.this.metadataOutputs) {
                metadataOutput.onMetadata(metadata);
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            SimpleExoPlayer2.this.setVideoSurfaceInternal(holder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            SimpleExoPlayer2.this.setVideoSurfaceInternal(null, false);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer2.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer2.this.setVideoSurfaceInternal(null, true);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    public static interface VideoListener {
        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

        public void onRenderedFirstFrame();
    }
}

