/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicloud.lonline.appender;

import org.apache.log4j.spi.LoggingEvent;
import org.dynamicloud.lonline.LonlineEvent;
import org.dynamicloud.lonline.LonlineLog;
import org.dynamicloud.lonline.LonlineSetting;
import org.dynamicloud.lonline.appender.AppenderSkeletonAdapter;
import org.dynamicloud.lonline.processor.LonlineProcessor;
import org.dynamicloud.util.StringUtils;

public class LonlineAppender
extends AppenderSkeletonAdapter
implements LonlineSetting {
    private LonlineProcessor processor = LonlineProcessor.Impl.getInstance(this);

    @Override
    protected void append(LoggingEvent loggingEvent) {
        LonlineLog log;
        String level = loggingEvent.getLevel().toString().toLowerCase();
        String text = loggingEvent.getMessage().toString();
        String trace = "";
        if (loggingEvent.getThrowableInformation() != null) {
            trace = StringUtils.join(loggingEvent.getThrowableInformation().getThrowable().getStackTrace(), "\n");
        }
        if (loggingEvent instanceof LonlineEvent) {
            log = ((LonlineEvent)loggingEvent).getAdditionalInformation();
            log.setBacktrace(trace);
            log.setLevel(level);
            log.setText(text);
        } else {
            log = new LonlineLog(level, text, trace);
        }
        this.processor.process(log);
    }
}

