/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.config;

import java.io.File;

public class SyncConfig {
    public static final String SYNC_WORK_PROP = "sync.work";
    public static final String DEFAULT_WORK_DIR = System.getProperty("user.home") + File.separator + "duracloud-sync-work";
    private static File workDir;

    protected SyncConfig() {
    }

    public static void setWorkDir(File newWorkDir) {
        workDir = newWorkDir;
    }

    public static File getWorkDir() {
        if (null == workDir) {
            workDir = new File(System.getProperty(SYNC_WORK_PROP, DEFAULT_WORK_DIR));
        }
        if (!workDir.exists()) {
            workDir.mkdirs();
            workDir.setWritable(true);
        }
        System.setProperty(SYNC_WORK_PROP, workDir.getAbsolutePath());
        return workDir;
    }
}

