/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends FilterInputStream {
    long bytesRead = 0L;

    public MonitoredInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public MonitoredInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value > -1) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.updateBytesRead(super.read(b, off, len));
    }

    public int updateBytesRead(int byteCount) {
        if (byteCount > 0) {
            this.bytesRead += (long)byteCount;
        }
        return byteCount;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

