/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.walker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.duracloud.sync.mgmt.FileExclusionManager;
import org.duracloud.sync.walker.DirWalker;

public class RestartDirWalker
extends DirWalker {
    private long lastBackup;
    private List<File> changedDirs;

    protected RestartDirWalker(List<File> topDirs, long lastBackup, FileExclusionManager fileExclusionManager) {
        super(topDirs, fileExclusionManager);
        this.lastBackup = lastBackup;
        this.changedDirs = new ArrayList<File>();
    }

    @Override
    protected void walkDirs() {
        super.walkDirs();
        if (this.changedDirs.size() > 0) {
            DirWalker dirWalker = new DirWalker(this.changedDirs, this.fileExclusionManager);
            dirWalker.walkDirs();
        }
    }

    @Override
    protected void handleFile(File file, int depth, Collection results) {
        if (file.lastModified() > this.lastBackup) {
            super.handleFile(file, depth, results);
        }
    }

    @Override
    protected boolean handleDirectory(File directory, int depth, Collection results) {
        if (directory.lastModified() > this.lastBackup) {
            this.changedDirs.add(directory);
        }
        return true;
    }

    public static DirWalker start(List<File> topDirs, long lastBackup, FileExclusionManager fileExclusionManager) {
        RestartDirWalker dirWalker = new RestartDirWalker(topDirs, lastBackup, fileExclusionManager);
        new Thread(dirWalker).start();
        return dirWalker;
    }
}

