/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.config;

import java.io.File;
import java.io.Serializable;
import java.util.List;

public class SyncToolConfig
implements Serializable {
    public static final String DEFAULT_UPDATE_SUFFIX = ".orig";
    private static final long DEFAULT_BACKUP_FREQUENCY = 300000L;
    private String host;
    private int port;
    private String context;
    private String username;
    private String password;
    private String storeId;
    private String spaceId;
    private File workDir;
    private List<File> contentDirs;
    private long pollFrequency;
    private long backupFrequency = 300000L;
    private int numThreads = 5;
    private long maxFileSize;
    private boolean syncDeletes;
    private boolean cleanStart;
    private boolean exitOnCompletion;
    private File excludeList;
    private String version;
    private boolean syncUpdates = true;
    private boolean renameUpdates = false;
    private String updateSuffix = ".orig";
    private String prefix;
    private boolean jumpStart = false;

    public String getPrintableConfig() {
        StringBuilder config = new StringBuilder();
        config.append("\n-------------------------------------------\n");
        config.append(" Sync Tool " + this.version + " - Configuration");
        config.append("\n-------------------------------------------\n");
        config.append("Content Directories:\n");
        for (File dir : this.getContentDirs()) {
            config.append("  ").append(dir.getAbsolutePath()).append("\n");
        }
        config.append("Content Name Prefix: ");
        config.append(this.getPrefix()).append("\n");
        config.append("DuraStore Host: ");
        config.append(this.getHost()).append("\n");
        config.append("DuraStore Port: ");
        config.append(this.getPort()).append("\n");
        config.append("DuraStore Username: ");
        config.append(this.getUsername()).append("\n");
        if (this.getStoreId() != null) {
            config.append("DuraCloud Store ID: ");
            config.append(this.getStoreId()).append("\n");
        }
        config.append("DuraCloud Space ID: ");
        config.append(this.getSpaceId()).append("\n");
        config.append("SyncTool Work Directory: ");
        config.append(this.getWorkDir()).append("\n");
        config.append("SyncTool Poll Frequency: ");
        config.append(this.getPollFrequency());
        config.append("\n");
        config.append("SyncTool Threads: ");
        config.append(this.getNumThreads()).append("\n");
        config.append("SyncTool Max File Size: ");
        config.append(this.getMaxFileSize()).append(" bytes\n");
        config.append("SyncTool Syncing Deletes: ");
        config.append(this.syncDeletes()).append("\n");
        if (this.getExcludeList() != null) {
            config.append("SyncTool Exclude List: ");
            config.append(this.getExcludeList()).append("\n");
        }
        config.append("Clean Start Mode: ");
        config.append(this.isCleanStart()).append("\n");
        config.append("Jump Start Mode: ");
        config.append(this.isJumpStart()).append("\n");
        config.append("SyncTool Exit on Completion: ");
        config.append(this.exitOnCompletion()).append("\n");
        config.append("Sync Updates: ");
        config.append(this.isSyncUpdates()).append("\n");
        config.append("Rename Updates: ");
        config.append(this.isRenameUpdates()).append("\n");
        if (this.isRenameUpdates()) {
            config.append("Rename Updates suffix: ");
            config.append(this.getUpdateSuffix()).append("\n");
        }
        config.append("-------------------------------------------\n");
        return config.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public List<File> getContentDirs() {
        return this.contentDirs;
    }

    public void setContentDirs(List<File> contentDirs) {
        this.contentDirs = contentDirs;
    }

    public long getPollFrequency() {
        return this.pollFrequency;
    }

    public void setPollFrequency(long pollFrequency) {
        this.pollFrequency = pollFrequency;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean syncDeletes() {
        return this.syncDeletes;
    }

    public void setSyncDeletes(boolean syncDeletes) {
        this.syncDeletes = syncDeletes;
    }

    public boolean isCleanStart() {
        return this.cleanStart;
    }

    public void setCleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
    }

    public boolean exitOnCompletion() {
        return this.exitOnCompletion;
    }

    public void setExitOnCompletion(boolean exitOnCompletion) {
        this.exitOnCompletion = exitOnCompletion;
    }

    public File getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(File excludeList) {
        this.excludeList = excludeList;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSyncUpdates() {
        return this.syncUpdates;
    }

    public void setSyncUpdates(boolean syncUpdates) {
        this.syncUpdates = syncUpdates;
    }

    public boolean isRenameUpdates() {
        return this.renameUpdates;
    }

    public void setRenameUpdates(boolean renameUpdates) {
        this.renameUpdates = renameUpdates;
    }

    public String getUpdateSuffix() {
        return this.updateSuffix;
    }

    public void setUpdateSuffix(String updateSuffix) {
        this.updateSuffix = updateSuffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isJumpStart() {
        return this.jumpStart;
    }

    public void setJumpStart(boolean jumpStart) {
        this.jumpStart = jumpStart;
    }

    public long getBackupFrequency() {
        return this.backupFrequency;
    }
}

