/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.walker;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteChecker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(DeleteChecker.class);
    private SyncEndpoint syncEndpoint;
    private String spaceId;
    private Iterator<String> filesList;
    private List<File> syncDirs;
    private boolean complete = false;
    private boolean stopped = false;
    private String prefix;

    protected DeleteChecker(SyncEndpoint syncEndpoint, String spaceId, List<File> syncDirs, String prefix) {
        this.syncEndpoint = syncEndpoint;
        this.spaceId = spaceId;
        this.syncDirs = syncDirs;
        this.prefix = prefix;
        this.filesList = syncEndpoint.getFilesList();
    }

    @Override
    public void run() {
        this.logger.info("Running Delete Checker");
        while (this.filesList.hasNext() && !this.stopped) {
            String contentId = this.filesList.next();
            if (null != this.prefix) {
                if (contentId.startsWith(this.prefix)) {
                    if (this.exists(contentId.substring(this.prefix.length()))) continue;
                    this.deleteContent(contentId);
                    continue;
                }
                this.deleteContent(contentId);
                continue;
            }
            if (this.exists(contentId)) continue;
            this.deleteContent(contentId);
        }
        this.complete = true;
    }

    private boolean exists(String fileToCheck) {
        boolean exists = false;
        for (File syncDir : this.syncDirs) {
            if (!new File(syncDir, fileToCheck).exists()) continue;
            exists = true;
        }
        this.logger.debug("Delete check on file: " + fileToCheck + ". File exists: " + exists);
        return exists;
    }

    private void deleteContent(final String contentId) {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    DeleteChecker.this.syncEndpoint.deleteContent(DeleteChecker.this.spaceId, contentId);
                    return "success";
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Failed to delete content item: " + contentId + " from space: " + this.spaceId + " due to: " + e.getMessage());
        }
    }

    public boolean checkComplete() {
        return this.complete;
    }

    public void stop() {
        this.stopped = true;
    }

    public static DeleteChecker start(SyncEndpoint syncEndpoint, String spaceId, List<File> syncDirs, String prefix) {
        DeleteChecker deleteChecker = new DeleteChecker(syncEndpoint, spaceId, syncDirs, prefix);
        new Thread(deleteChecker).start();
        return deleteChecker;
    }
}

