/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.provider;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StatelessStorageProvider;
import org.duracloud.storage.provider.StorageProvider;

public class BrokeredStorageProvider
implements StorageProvider {
    private final StatelessStorageProvider dispatchProvider;
    private final StorageProvider targetProvider;
    private final StorageProviderType targetType;
    private String storeId;

    public BrokeredStorageProvider(StatelessStorageProvider dispatchProvider, StorageProvider targetProvider, StorageProviderType targetType, String storeId) {
        this.dispatchProvider = dispatchProvider;
        this.targetProvider = targetProvider;
        this.targetType = targetType;
        this.storeId = storeId;
    }

    public StorageProviderType getTargetType() {
        return this.targetType;
    }

    @Override
    public StorageProviderType getStorageProviderType() {
        return this.dispatchProvider.getStorageProviderType(this.targetProvider);
    }

    @Override
    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) throws StorageException {
        return this.dispatchProvider.addContent(this.targetProvider, this.storeId, spaceId, contentId, contentMimeType, userProperties, contentSize, contentChecksum, content);
    }

    @Override
    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        return this.dispatchProvider.copyContent(this.targetProvider, this.storeId, sourceSpaceId, sourceContentId, destSpaceId, destContentId);
    }

    @Override
    public void createSpace(String spaceId) throws StorageException {
        this.dispatchProvider.createSpace(this.targetProvider, this.storeId, spaceId);
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws StorageException {
        this.dispatchProvider.deleteContent(this.targetProvider, this.storeId, spaceId, contentId);
    }

    @Override
    public void deleteSpace(String spaceId) throws StorageException {
        this.dispatchProvider.deleteSpace(this.targetProvider, this.storeId, spaceId);
    }

    @Override
    public InputStream getContent(String spaceId, String contentId) throws StorageException {
        return this.dispatchProvider.getContent(this.targetProvider, this.storeId, spaceId, contentId);
    }

    @Override
    public Map<String, String> getContentProperties(String spaceId, String contentId) throws StorageException {
        return this.dispatchProvider.getContentProperties(this.targetProvider, this.storeId, spaceId, contentId);
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId, String prefix) throws StorageException {
        return this.dispatchProvider.getSpaceContents(this.targetProvider, this.storeId, spaceId, prefix);
    }

    @Override
    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) throws StorageException {
        return this.dispatchProvider.getSpaceContentsChunked(this.targetProvider, this.storeId, spaceId, prefix, maxResults, marker);
    }

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) throws StorageException {
        return this.dispatchProvider.getSpaceProperties(this.targetProvider, this.storeId, spaceId);
    }

    @Override
    public Iterator<String> getSpaces() throws StorageException {
        return this.dispatchProvider.getSpaces(this.targetProvider, this.storeId);
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) throws StorageException {
        this.dispatchProvider.setContentProperties(this.targetProvider, this.storeId, spaceId, contentId, contentProperties);
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) {
        return this.dispatchProvider.getSpaceACLs(this.targetProvider, this.storeId, spaceId);
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        this.dispatchProvider.setSpaceACLs(this.targetProvider, this.storeId, spaceId, spaceACLs);
    }
}

