/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncoptimize.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.duracloud.client.ContentStore;
import org.duracloud.error.ContentStoreException;
import org.duracloud.sync.SyncToolInitializer;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.syncoptimize.config.SyncOptimizeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTester {
    private SyncOptimizeConfig syncOptConfig;
    private File dataDir;
    private File workDir;
    private ContentStore contentStore;
    private String prefix;
    private final Logger log = LoggerFactory.getLogger(SyncTester.class);

    public SyncTester(SyncOptimizeConfig syncOptConfig, File dataDir, File workDir, ContentStore contentStore, String prefix) {
        this.syncOptConfig = syncOptConfig;
        this.dataDir = dataDir;
        this.workDir = workDir;
        this.contentStore = contentStore;
        this.prefix = prefix;
    }

    public long runSyncTest(int threads) {
        this.cleanupSync();
        long start = System.currentTimeMillis();
        this.performSync(threads);
        long end = System.currentTimeMillis();
        this.cleanupSync();
        return end - start;
    }

    private void performSync(int threads) {
        SyncToolInitializer syncTool = this.getSyncTool();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-h");
        args.add(this.syncOptConfig.getHost());
        args.add("-s");
        args.add(this.syncOptConfig.getSpaceId());
        args.add("-u");
        args.add(this.syncOptConfig.getUsername());
        args.add("-p");
        args.add(this.syncOptConfig.getPassword());
        args.add("-c");
        args.add(this.dataDir.getAbsolutePath());
        args.add("-w");
        args.add(this.workDir.getAbsolutePath());
        args.add("-a");
        args.add(this.prefix);
        args.add("-x");
        args.add("-l");
        args.add("-j");
        args.add("-t");
        args.add(String.valueOf(threads));
        syncTool.runSyncTool(args.toArray(new String[0]));
    }

    protected SyncToolInitializer getSyncTool() {
        return new SyncToolInitializer();
    }

    protected void cleanupSync() {
        try {
            String spaceId = this.syncOptConfig.getSpaceId();
            Iterator testContent = this.contentStore.getSpaceContents(spaceId, this.prefix);
            while (testContent.hasNext()) {
                this.contentStore.deleteContent(spaceId, (String)testContent.next());
            }
        }
        catch (ContentStoreException e) {
            this.log.error("Error cleaning up DuraStore content: " + e.getMessage());
        }
        ChangedList.getInstance().clear();
        StatusManager.getInstance().clear();
    }
}

