/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import org.duracloud.sync.mgmt.ChangeHandler;
import org.duracloud.sync.mgmt.ChangedFile;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeWatcher
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ChangeWatcher.class);
    private boolean continueWatch;
    private ChangedList changedList;
    private ChangeHandler handler;
    private long watchFrequency;
    private StatusManager status;

    public ChangeWatcher(ChangedList changedList, ChangeHandler handler, long watchFrequency) {
        this.changedList = changedList;
        this.handler = handler;
        this.watchFrequency = watchFrequency;
        this.status = StatusManager.getInstance();
        this.continueWatch = true;
    }

    @Override
    public void run() {
        while (this.continueWatch) {
            ChangedFile changedFile = this.changedList.reserve();
            if (changedFile != null) {
                boolean success = this.handler.handleChangedFile(changedFile);
                if (success) {
                    this.status.startingWork();
                    continue;
                }
                changedFile.unreserve();
                continue;
            }
            this.sleep(this.watchFrequency);
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.logger.warn("ChangeWatcher thread interrupted");
        }
    }

    public void endWatch() {
        this.continueWatch = false;
    }
}

