/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.manifest.xml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.duracloud.ChunkType;
import org.duracloud.ChunksManifestType;
import org.duracloud.ChunksType;
import org.duracloud.HeaderType;
import org.duracloud.SourceContentType;
import org.duracloud.chunk.manifest.ChunksManifestBean;

public class ManifestElementWriter {
    public static ChunksManifestType createChunksManifestElementFrom(ChunksManifestBean manifest) {
        ChunksManifestType manifestType = ChunksManifestType.Factory.newInstance();
        ManifestElementWriter.populateElementFromObject(manifestType, manifest);
        return manifestType;
    }

    private static void populateElementFromObject(ChunksManifestType manifestType, ChunksManifestBean manifest) {
        HeaderType headerType = manifestType.addNewHeader();
        ManifestElementWriter.populateHeaderType(headerType, manifest.getHeader());
        ChunksType chunksType = manifestType.addNewChunks();
        ManifestElementWriter.populateChunksType(chunksType, manifest.getEntries());
    }

    private static void populateHeaderType(HeaderType headerType, ChunksManifestBean.ManifestHeader header) {
        long size;
        String md5;
        String mime;
        headerType.setSchemaVersion("0.2");
        SourceContentType sourceContentType = headerType.addNewSourceContent();
        String contentId = header.getSourceContentId();
        if (!StringUtils.isBlank(contentId)) {
            sourceContentType.setContentId(contentId);
        }
        if (!StringUtils.isBlank(mime = header.getSourceMimetype())) {
            sourceContentType.setMimetype(mime);
        }
        if (!StringUtils.isBlank(md5 = header.getSourceMD5())) {
            sourceContentType.setMd5(md5);
        }
        if ((size = header.getSourceByteSize()) > -1L) {
            sourceContentType.setByteSize(size);
        }
    }

    private static void populateChunksType(ChunksType chunksType, List<ChunksManifestBean.ManifestEntry> entries) {
        if (null != entries && entries.size() > 0) {
            for (ChunksManifestBean.ManifestEntry entry : entries) {
                int index;
                long size;
                String md5;
                ChunkType chunkType = chunksType.addNewChunk();
                String chunkId = entry.getChunkId();
                if (!StringUtils.isBlank(chunkId)) {
                    chunkType.setChunkId(chunkId);
                }
                if (!StringUtils.isBlank(md5 = entry.getChunkMD5())) {
                    chunkType.setMd5(md5);
                }
                if ((size = entry.getByteSize()) > -1L) {
                    chunkType.setByteSize(size);
                }
                if ((index = entry.getIndex()) <= -1) continue;
                chunkType.setIndex(index);
            }
        }
    }
}

